/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.framed;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramedStandardDrawers
extends BlockStandardDrawers
implements IFramedBlock {
    public BlockFramedStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockFramedStandardDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, properties);
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    @Override
    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.material().read(stack);
        blockEntity.setChanged();
    }

    @Override
    protected ItemStack getMainDrop(BlockState state, BlockEntityDrawers tile) {
        ItemStack drop = super.getMainDrop(state, tile);
        if (!tile.material().isEmpty()) {
            drop.set((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return drop;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        BlockEntityDrawers tile = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityDrawers.class);
        if (tile != null && !tile.material().isEmpty()) {
            stack.set((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return stack;
    }

    @Override
    public IFramedBlockEntity getFramedBlockEntity(@NotNull Level world, @NotNull BlockPos pos) {
        return WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
    }

    @Override
    public boolean supportsFrameMaterial(FrameMaterial material) {
        return true;
    }
}

