/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.framed;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityTrim;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramedTrim
extends BlockTrim
implements EntityBlock,
IFramedBlock {
    public BlockFramedTrim(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntityTrim blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityTrim.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.material().read(stack);
        blockEntity.setChanged();
    }

    @Override
    public boolean canUseForRetrim() {
        return false;
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntityTrim)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntityTrim tile) {
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        if (!tile.material().isEmpty()) {
            drop.set((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return drop;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        BlockEntityTrim tile = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityTrim.class);
        if (tile != null && !tile.material().isEmpty()) {
            stack.set((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)new FrameData(tile.material()));
        }
        return stack;
    }

    public BlockEntityTrim newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityTrim)ModServices.RESOURCE_FACTORY.createBlockEntityTrim().create(pos, state);
    }

    @Override
    public IFramedBlockEntity getFramedBlockEntity(@NotNull Level world, @NotNull BlockPos pos) {
        return WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityTrim.class);
    }

    @Override
    public boolean supportsFrameMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new MatchException(null, null);
            case FrameMaterial.SIDE, FrameMaterial.TRIM -> true;
            case FrameMaterial.FRONT -> false;
        };
    }
}

