/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageGuiGraphics
extends GuiGraphics {
    private final Minecraft minecraft;
    @NotNull
    public ItemStack overrideStack;

    public StorageGuiGraphics(Minecraft p_283406_, MultiBufferSource.BufferSource p_282238_) {
        super(p_283406_, p_282238_);
        this.minecraft = p_283406_;
        this.overrideStack = ItemStack.EMPTY;
    }

    public void renderItemDecorations(Font font, ItemStack item, int x, int y, @Nullable String text) {
        if (item != this.overrideStack) {
            super.renderItemDecorations(font, item, x, y, text);
            return;
        }
        if (!item.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            item = ItemStackHelper.decodeItemStack(item);
            float scale = 0.5f;
            float xoff = 0.0f;
            int stackSize = item.getCount();
            if (ItemStackHelper.isStackEncoded(item)) {
                stackSize = 0;
            }
            this.pose().pushPose();
            if (stackSize >= 0 || text != null) {
                text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.width(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                int color = 0xFFFFFF;
                if (stackSize == 0) {
                    color = 0xFF6060;
                }
                this.pose().scale(scale, scale, 1.0f);
                this.pose().translate(0.0, 0.0, 200.0);
                this.drawString(font, text, textX, textY, color, true);
            }
            if (item.getItem().isBarVisible(item)) {
                int barWidth = item.getItem().getBarWidth(item);
                int color = item.getItem().getBarColor(item);
                int x1 = x + 2;
                int y1 = y + 13;
                this.fill(RenderType.guiOverlay(), x1, y1, x1 + 13, y1 + 2, -16777216);
                this.fill(RenderType.guiOverlay(), x1, y1, x1 + barWidth, y1 + 1, color | 0xFF000000);
            }
            float f2 = f = (localplayer = this.minecraft.player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(item, this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true));
            if (f > 0.0f) {
                int y1 = y + Mth.floor((float)(16.0f * (1.0f - f)));
                int y2 = y1 + Mth.ceil((float)(16.0f * f));
                this.fill(RenderType.guiOverlay(), x, y1, x + 16, y2, Integer.MAX_VALUE);
            }
            this.pose().popPose();
        }
    }
}

