/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteReplacementModel
extends ParentModel {
    private TextureAtlasSprite sprite;
    private Map<String, List<BakedQuad>> cache = new HashMap<String, List<BakedQuad>>();

    public SpriteReplacementModel(@NotNull BakedModel parent, TextureAtlasSprite sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull BakedModel parent, ItemStack stack) {
        super(parent);
        Item item;
        if (stack != null && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockRenderDispatcher disp = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = disp.getBlockModel(block.defaultBlockState());
            this.sprite = model.getParticleIcon();
        }
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction dir, RandomSource rand) {
        if (this.sprite == null) {
            return super.getQuads(state, dir, rand);
        }
        String key = this.cacheKey(state, dir);
        List<BakedQuad> list = this.cache.getOrDefault(key, null);
        if (list == null) {
            list = super.getQuads(state, dir, rand).stream().map(bakedQuad -> new ReplacementBakedQuad((BakedQuad)bakedQuad, this.sprite)).toList();
            this.cache.put(key, list);
        }
        return list;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        if (this.sprite == null) {
            return super.getParticleIcon();
        }
        return this.sprite;
    }

    private String cacheKey(@Nullable BlockState state, @Nullable Direction dir) {
        return (state != null ? state.toString() : "") + "#" + (dir != null ? dir.toString() : "");
    }

    private static class ReplacementBakedQuad
    extends BakedQuad {
        TextureAtlasSprite sprite;

        public ReplacementBakedQuad(BakedQuad quad, @NotNull TextureAtlasSprite sprite) {
            super((int[])quad.getVertices().clone(), quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade(), quad.getLightEmission());
            this.sprite = sprite;
            this.remapQuad();
        }

        @NotNull
        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        private void remapQuad() {
            for (int i = 0; i < 4; ++i) {
                int blk = DefaultVertexFormat.BLOCK.getVertexSize() / 4 * i;
                int offset = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV) / 4;
                this.vertices[blk + offset] = Float.floatToRawIntBits(this.sprite.getU(this.getUnInterpolatedU(((BakedQuad)this).sprite, Float.intBitsToFloat(this.vertices[blk + offset]))));
                this.vertices[blk + offset + 1] = Float.floatToRawIntBits(this.sprite.getV(this.getUnInterpolatedV(((BakedQuad)this).sprite, Float.intBitsToFloat(this.vertices[blk + offset + 1]))));
            }
        }

        private float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
            float diff = sprite.getU1() - sprite.getU0();
            return (u - sprite.getU0()) / diff;
        }

        private float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
            float diff = sprite.getV1() - sprite.getV0();
            return (v - sprite.getV0()) / diff;
        }
    }
}

