/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityTrim;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.registry.ChameleonRegistry;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class ModBlockEntities {
    public static final ChameleonRegistry<BlockEntityType<?>> BLOCK_ENTITIES = ChameleonServices.REGISTRY.create(BuiltInRegistries.BLOCK_ENTITY_TYPE, "storagedrawers");
    public static final Set<RegistryEntry<? extends BlockEntityType<? extends BlockEntityDrawers>>> DRAWER_TYPES = new HashSet<RegistryEntry<? extends BlockEntityType<? extends BlockEntityDrawers>>>();
    public static final Set<RegistryEntry<? extends BlockEntityType<? extends BlockEntityDrawers>>> FRAMING_TABLE_TYPES = new HashSet<RegistryEntry<? extends BlockEntityType<? extends BlockEntityDrawers>>>();
    public static final RegistryEntry<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_1 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_1", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(1), BlockStandardDrawers.class, 1);
    public static final RegistryEntry<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_2", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(2), BlockStandardDrawers.class, 2);
    public static final RegistryEntry<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_4 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_4", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(4), BlockStandardDrawers.class, 4);
    public static final RegistryEntry<BlockEntityType<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_2", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(2), BlockCompDrawers.class, 2);
    public static final RegistryEntry<BlockEntityType<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_3 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_3", ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(3), BlockCompDrawers.class, 3);
    public static final RegistryEntry<BlockEntityType<BlockEntityController>> CONTROLLER = ModBlockEntities.registerControllerBlockEntityType("controller", ModServices.RESOURCE_FACTORY.createBlockEntityController());
    public static final RegistryEntry<BlockEntityType<BlockEntityControllerIO>> CONTROLLER_IO = ModBlockEntities.registerControllerIOBlockEntityType("controller_io", ModServices.RESOURCE_FACTORY.createBlockEntityControllerIO());
    public static final RegistryEntry<BlockEntityType<BlockEntityTrim>> TRIM = BLOCK_ENTITIES.register("trim", () -> new BlockEntityType(ModServices.RESOURCE_FACTORY.createBlockEntityTrim(), Set.of((Block)ModBlocks.FRAMED_TRIM.get())));
    public static final RegistryEntry<BlockEntityType<BlockEntityFramingTable>> FRAMING_TABLE = BLOCK_ENTITIES.register("framing_table", () -> new BlockEntityType(ModServices.RESOURCE_FACTORY.createBlockEntityFramingTable(), Set.of((Block)ModBlocks.FRAMING_TABLE.get())));

    private ModBlockEntities() {
    }

    private static <BE extends BlockEntityDrawers, B extends BlockDrawers> RegistryEntry<BlockEntityType<BE>> registerDrawerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        RegistryEntry<BlockEntityType<BE>> ro = ModBlockEntities.registerBlockEntityType(name, blockEntitySupplier, drawerBlockClass, size);
        DRAWER_TYPES.add(ro);
        return ro;
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<BlockEntityType<BE>> registerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        return BLOCK_ENTITIES.register(name, () -> new BlockEntityType(blockEntitySupplier, Set.of((Block[])ModBlocks.getDrawersOfTypeAndSize(drawerBlockClass, size).toArray(Block[]::new))));
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<BlockEntityType<BE>> registerControllerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier) {
        return BLOCK_ENTITIES.register(name, () -> new BlockEntityType(blockEntitySupplier, Set.of((Block[])ModBlocks.getControllers().toArray(Block[]::new))));
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> RegistryEntry<BlockEntityType<BE>> registerControllerIOBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier) {
        return BLOCK_ENTITIES.register(name, () -> new BlockEntityType(blockEntitySupplier, Set.of((Block[])ModBlocks.getControllerIOs().toArray(Block[]::new))));
    }

    public static void init(ChameleonInit.InitContext context) {
        BLOCK_ENTITIES.init(context);
    }

    public static Stream<BlockEntityType<? extends BlockEntityDrawers>> getDrawerTypes() {
        return DRAWER_TYPES.stream().map(Supplier::get);
    }
}

