/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerFramingTable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class FramingTableScreen
extends AbstractContainerScreen<ContainerFramingTable> {
    private static final ResourceLocation guiTextires = ModConstants.loc("textures/gui/framing.png");
    private final ResourceLocation background;
    private final Inventory inventory;

    public FramingTableScreen(ContainerFramingTable container, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)container, playerInv, name);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.background = guiTextires;
        this.inventory = playerInv;
    }

    public void render(@NotNull GuiGraphics graphics, int x, int y, float f) {
        super.render(graphics, x, y, f);
        this.renderTooltip(graphics, x, y);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.inventory.getDisplayName().getString(), 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderType::guiTextured, this.background, guiX, guiY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }
}

