/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.GrassColorSource;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.CompositeModel;
import net.minecraft.client.renderer.item.EmptyModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SpecialModelWrapper;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.ItemLike;

public abstract class ItemInfoGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, ItemInfoBuilder> infos = new HashMap<ResourceLocation, ItemInfoBuilder>();

    public ItemInfoGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        RegistryOps ops = ResourceGenerator.registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (ItemInfoBuilder builder : this.infos.values()) {
            JsonObject json = ((JsonElement)ClientItem.CODEC.encodeStart((DynamicOps)ops, (Object)builder.toClientItem()).getOrThrow()).getAsJsonObject();
            ResourceLocation identifier = builder.location;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.getNamespace(), "items", identifier.getPath());
        }
    }

    protected ItemInfoBuilder info(ResourceLocation item) {
        return this.infos.computeIfAbsent(item, ItemInfoBuilder::new);
    }

    protected ItemInfoBuilder info(String namespace, String identifier) {
        return this.info(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier));
    }

    protected ItemInfoBuilder info(String identifier) {
        return this.info(this.modid, identifier);
    }

    protected ItemInfoBuilder info(ItemLike item) {
        return this.info(Registries.ITEMS.getIdentifier(item.asItem()));
    }

    protected ItemInfoBuilder simpleInfo(ItemLike item, String model) {
        return this.info(item).model(this.model(model));
    }

    protected ModelModelBuilder model(ResourceLocation location) {
        return new ModelModelBuilder(location);
    }

    protected ModelModelBuilder model(String namespace, String path) {
        return this.model(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    protected ModelModelBuilder model(String location) {
        return this.model(this.modid, location);
    }

    protected CompositeModelBuilder compositeModel() {
        return new CompositeModelBuilder();
    }

    protected ModelBuilder emptyModel() {
        return ModelBuilder.of(new EmptyModel.Unbaked());
    }

    protected ModelBuilder specialModel(SpecialModelRenderer.Unbaked specialModel, ResourceLocation baseModel) {
        return ModelBuilder.of(new SpecialModelWrapper.Unbaked(baseModel, specialModel));
    }

    @Override
    public String getName() {
        return this.modName + " Item Info Generator";
    }

    protected static class ItemInfoBuilder {
        private final ResourceLocation location;
        private boolean handAnimationOnSwap = true;
        private ModelBuilder model;

        protected ItemInfoBuilder(ResourceLocation location) {
            this.location = location;
        }

        public ItemInfoBuilder noHandAnimationOnSwap() {
            this.handAnimationOnSwap = false;
            return this;
        }

        public ItemInfoBuilder model(ModelBuilder model) {
            this.model = model;
            return this;
        }

        public ItemInfoBuilder model(ItemModel.Unbaked model) {
            return this.model(ModelBuilder.of(model));
        }

        private ClientItem toClientItem() {
            EmptyModel.Unbaked model = this.model == null ? new EmptyModel.Unbaked() : this.model.toItemModel();
            return new ClientItem((ItemModel.Unbaked)model, new ClientItem.Properties(this.handAnimationOnSwap));
        }
    }

    protected static class ModelModelBuilder
    extends ModelBuilder {
        private final ResourceLocation model;
        private final List<ItemTintSource> tintSources = new ArrayList<ItemTintSource>();

        protected ModelModelBuilder(ResourceLocation model) {
            this.model = model;
        }

        @Override
        protected ItemModel.Unbaked toItemModel() {
            return new BlockModelWrapper.Unbaked(this.model, this.tintSources);
        }

        public ModelModelBuilder addTintSource(ItemTintSource tintSource) {
            this.tintSources.add(tintSource);
            return this;
        }

        public ModelModelBuilder addConstantTint(int rgb) {
            return this.addTintSource((ItemTintSource)new Constant(rgb));
        }

        public ModelModelBuilder addConstantTint(float red, float green, float blue) {
            if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f) {
                throw new IllegalArgumentException("Color component values must be between 0 and 1!");
            }
            return this.addTintSource((ItemTintSource)new Constant(ARGB.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue)));
        }

        public ModelModelBuilder addDyeComponentTint(int defaultColor) {
            return this.addTintSource((ItemTintSource)new Dye(defaultColor));
        }

        public ModelModelBuilder addGrassTint(float temperature, float downfall) {
            if (temperature < 0.0f || temperature > 1.0f) {
                throw new IllegalArgumentException("Temperature must be between 0 and 1!");
            }
            if (downfall < 0.0f || downfall > 1.0f) {
                throw new IllegalArgumentException("Downfall must be between 0 and 1!");
            }
            return this.addTintSource((ItemTintSource)new GrassColorSource(temperature, downfall));
        }
    }

    protected static abstract class ModelBuilder {
        private ModelBuilder() {
        }

        abstract ItemModel.Unbaked toItemModel();

        private static ModelBuilder of(final Object model) {
            if (!(model instanceof ItemModel.Unbaked)) {
                throw new IllegalArgumentException("Model must be an instance of " + ItemModel.Unbaked.class.getName());
            }
            return new ModelBuilder(){

                @Override
                ItemModel.Unbaked toItemModel() {
                    return (ItemModel.Unbaked)model;
                }
            };
        }
    }

    protected static class CompositeModelBuilder
    extends ModelBuilder {
        private final List<ModelBuilder> models = new ArrayList<ModelBuilder>();

        protected CompositeModelBuilder() {
        }

        @Override
        protected ItemModel.Unbaked toItemModel() {
            return new CompositeModel.Unbaked(this.models.stream().map(ModelBuilder::toItemModel).toList());
        }

        public CompositeModelBuilder addModel(ModelBuilder model) {
            this.models.add(model);
            return this;
        }

        public CompositeModelBuilder addModel(ItemModel.Unbaked model) {
            return this.addModel(ModelBuilder.of(model));
        }
    }
}

