/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialBlockModelRendererEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import org.jetbrains.annotations.ApiStatus;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    private static boolean haveModelsBeenRegistered = false;
    private final String modid;
    private final List<Pair<ResourceLocation, Consumer<BakedModel>>> modelConsumers = new ArrayList<Pair<ResourceLocation, Consumer<BakedModel>>>();
    private final Map<ResourceLocation, Function<BakedModel, BakedModel>> modelOverwrites = new HashMap<ResourceLocation, Function<BakedModel, BakedModel>>();
    private final List<Pair<Supplier<Block>, Function<BakedModel, BakedModel>>> blockModelOverwrites = new ArrayList<Pair<Supplier<Block>, Function<BakedModel, BakedModel>>>();
    private final List<Pair<Supplier<Item>, Function<ItemModel, ItemModel>>> itemModelOverwrites = new ArrayList<Pair<Supplier<Item>, Function<ItemModel, ItemModel>>>();
    private final List<Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?, ?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<BlockEntityType<?>>, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureAtlasSprites = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final List<Pair<ResourceLocation, MapCodec<? extends SpecialModelRenderer.Unbaked>>> specialModelRenderers = new ArrayList<Pair<ResourceLocation, MapCodec<? extends SpecialModelRenderer.Unbaked>>>();
    private final List<Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>>> blockSpecialRenderers = new ArrayList<Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>>>();
    private final List<Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, Supplier<RenderType>>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, Supplier<RenderType>>>();
    private final List<Pair<ResourceLocation, MapCodec<? extends ItemModel.Unbaked>>> itemModelTypes = new ArrayList<Pair<ResourceLocation, MapCodec<? extends ItemModel.Unbaked>>>();
    private boolean passedRegisterRenderers;
    private boolean passedTextureStitch;

    @ApiStatus.Internal
    public static Set<ResourceLocation> getModelConsumerLocations() {
        haveModelsBeenRegistered = true;
        return REGISTRATION_HELPER_MAP.values().stream().flatMap(ClientRegistrationHandler::modelConsumerLocations).collect(Collectors.toSet());
    }

    @ApiStatus.Internal
    public static void applyModelConsumersInternal(Function<ResourceLocation, BakedModel> modelGetter) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.handleModelConsumers(modelGetter));
    }

    @ApiStatus.Internal
    public static Map<ResourceLocation, Function<BakedModel, BakedModel>> gatherModelOverwritesInternal() {
        return ClientRegistrationHandler.combineModelOverwrites(handler -> handler.modelOverwrites);
    }

    @ApiStatus.Internal
    public static Map<ResourceLocation, Function<BakedModel, BakedModel>> gatherBlockModelOverwritesInternal() {
        return ClientRegistrationHandler.combineModelOverwrites(handler -> handler.blockModelOverwrites.stream().collect(Collectors.toMap(p -> Registries.BLOCKS.getIdentifier((Block)((Supplier)p.left()).get()), Pair::right)));
    }

    @ApiStatus.Internal
    public static Map<ResourceLocation, Function<ItemModel, ItemModel>> gatherItemModelOverwritesInternal() {
        return ClientRegistrationHandler.combineModelOverwrites(handler -> handler.itemModelOverwrites.stream().collect(Collectors.toMap(p -> Registries.ITEMS.getIdentifier((Item)((Supplier)p.left()).get()), Pair::right)));
    }

    private static <S, T> Map<ResourceLocation, Function<T, T>> combineModelOverwrites(Function<ClientRegistrationHandler, Map<ResourceLocation, Function<T, T>>> overwritesExtractor) {
        haveModelsBeenRegistered = true;
        HashMap combined = new HashMap();
        REGISTRATION_HELPER_MAP.forEach((modid, handler) -> ((Map)overwritesExtractor.apply((ClientRegistrationHandler)handler)).forEach((location, overwrite) -> {
            Function<Object, Object> encapsulated = model -> {
                try {
                    return overwrite.apply(model);
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an error whilst computing model overwrite for mod '" + modid + "'", e);
                }
            };
            combined.compute((ResourceLocation)location, (l, f) -> f == null ? encapsulated : f.andThen(encapsulated));
        }));
        return combined;
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    @ApiStatus.Internal
    public static void collectSprites(ResourceLocation atlas, Consumer<ResourceLocation> spriteConsumer) {
        for (ClientRegistrationHandler value : REGISTRATION_HELPER_MAP.values()) {
            value.addSprites(atlas, spriteConsumer);
        }
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        IEventBus eventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        eventBus.addListener(this::handleRegisterRenderersEvent);
        eventBus.addListener(this::handleRegisterMenuScreensEvent);
        eventBus.addListener(this::handleRegisterSpecialModelRenderersEvent);
        eventBus.addListener(this::handleRegisterSpecialBlockModelRenderersEvent);
        eventBus.addListener(this::handleRegisterItemModelsEvent);
    }

    public void registerModelConsumer(ResourceLocation location, Consumer<BakedModel> consumer) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model consumer after model registry has been completed!");
        }
        this.modelConsumers.add(Pair.of(location, consumer));
    }

    public void registerModelConsumer(String namespace, String identifier, Consumer<BakedModel> consumer) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModelConsumer(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), consumer);
    }

    public void registerModelConsumer(String identifier, Consumer<BakedModel> consumer) {
        this.registerModelConsumer(this.modid, identifier, consumer);
    }

    public void registerModelOverwrite(ResourceLocation location, Function<BakedModel, BakedModel> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after model baking has completed!");
        }
        this.modelOverwrites.compute(location, (l, f) -> {
            if (f == null) {
                return modelOverwrite;
            }
            return f.andThen(modelOverwrite);
        });
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<BakedModel, BakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<BakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, BakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<BakedModel, BakedModel> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.blockModelOverwrites.add(Pair.of(block, modelOverwrite));
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<BakedModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, BakedModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<ItemModel, ItemModel> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.itemModelOverwrites.add(Pair.of(item, modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<ItemModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (ItemModel model) -> (ItemModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, ItemModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (ItemModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Function<EntityRendererProvider.Context, EntityRenderer<? super T, ?>> entityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Supplier<EntityRenderer<? super T, ?>> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> (EntityRenderer)entityRenderer.get());
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, EntityRenderer<? super T, ?> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> entityRenderer);
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>> blockEntityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<BlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> (BlockEntityRenderer)blockEntityRenderer.get());
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, BlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> blockEntityRenderer);
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, ResourceLocation spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (textureAtlas.getPath().startsWith("textures/atlas/") && textureAtlas.getPath().endsWith(".png")) {
            textureAtlas = ResourceLocation.fromNamespaceAndPath((String)textureAtlas.getNamespace(), (String)textureAtlas.getPath().substring("textures/atlas/".length(), textureAtlas.getPath().length() - ".png".length()));
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + String.valueOf(spriteLocation) + "' for atlas '" + String.valueOf(textureAtlas) + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)spriteLocation));
    }

    public void registerSpecialModelRenderer(String identifier, MapCodec<? extends SpecialModelRenderer.Unbaked> codec) {
        this.specialModelRenderers.add(Pair.of(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)identifier), codec));
    }

    public void registerBlockSpecialModelRenderer(Supplier<Block> block, Supplier<SpecialModelRenderer.Unbaked> renderer) {
        this.blockSpecialRenderers.add(Pair.of(block, renderer));
    }

    public void registerBlockSpecialModelRenderer(Block block, SpecialModelRenderer.Unbaked renderer) {
        this.registerBlockSpecialModelRenderer(() -> block, () -> renderer);
    }

    public void registerCustomItemRenderer(String identifier, final Supplier<CustomItemRenderer> itemRenderer) {
        final Holder<MapCodec> holder = new Holder<MapCodec>();
        MapCodec codec = MapCodec.unit((Object)new SpecialModelRenderer.Unbaked(){
            SpecialModelRenderer<?> renderer = null;

            public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
                if (this.renderer == null) {
                    this.renderer = CustomItemRenderer.toSpecialModelRenderer((CustomItemRenderer)itemRenderer.get());
                }
                return this.renderer;
            }

            public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
                return (MapCodec)holder.get();
            }
        });
        holder.set(codec);
        this.registerSpecialModelRenderer(identifier, (MapCodec<? extends SpecialModelRenderer.Unbaked>)codec);
    }

    public void registerCustomItemRenderer(String identifier, CustomItemRenderer itemRenderer) {
        this.registerCustomItemRenderer(identifier, () -> itemRenderer);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, Supplier<RenderType> renderTypeSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, RenderType renderType) {
        this.registerBlockModelRenderType(block, renderType);
    }

    public void registerBlockModelRenderType(Block block, Supplier<RenderType> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::solid);
    }

    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::solid);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::cutoutMipped);
    }

    public void registerBlockModelCutoutMippedRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::cutoutMipped);
    }

    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::cutout);
    }

    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::cutout);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::translucent);
    }

    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::translucent);
    }

    public void registerItemModelType(String identifier, MapCodec<? extends ItemModel.Unbaked> codec) {
        this.itemModelTypes.add(Pair.of(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)identifier), codec));
    }

    private void handleRegisterRenderersEvent(EntityRenderersEvent.RegisterRenderers e) {
        this.passedRegisterRenderers = true;
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?, ?>>> entry : this.entityRenderers) {
            EntityType<?> entityType = entry.left().get();
            if (entityType == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(entityType)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + String.valueOf(Registries.ENTITY_TYPES.getIdentifier(entityType)) + "'!");
            }
            entityTypes.add(entityType);
            e.registerEntityRenderer(entityType, ((Function)entry.right())::apply);
        }
        HashSet<BlockEntityType> blockEntityTypes = new HashSet<BlockEntityType>();
        for (Pair pair : this.blockEntityRenderers) {
            BlockEntityType blockEntityType = (BlockEntityType)((Supplier)pair.left()).get();
            if (blockEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(blockEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + String.valueOf(Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType)) + "'!");
            }
            blockEntityTypes.add(blockEntityType);
            e.registerBlockEntityRenderer(blockEntityType, ((Function)pair.right())::apply);
        }
        HashSet<Block> blocks = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<RenderType>> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (blocks.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            RenderType renderType = entry.right().get();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            blocks.add(block);
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
        }
    }

    private void handleRegisterMenuScreensEvent(RegisterMenuScreensEvent e) {
        HashSet menuTypes = new HashSet();
        for (Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>> entry : this.containerScreens) {
            MenuType<?> menuType = entry.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (menuTypes.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + String.valueOf(Registries.MENU_TYPES.getIdentifier(menuType)) + "'!");
            }
            menuTypes.add(menuType);
            e.register(menuType, entry.right()::apply);
        }
    }

    private void handleRegisterSpecialModelRenderersEvent(RegisterSpecialModelRendererEvent e) {
        this.specialModelRenderers.forEach(p -> e.register((ResourceLocation)p.left(), (MapCodec)p.right()));
    }

    private void handleRegisterSpecialBlockModelRenderersEvent(RegisterSpecialBlockModelRendererEvent e) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<SpecialModelRenderer.Unbaked>> entry : this.blockSpecialRenderers) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Special model renderer registered for null block!");
            }
            if (blocks.contains(block)) {
                throw new RuntimeException("Duplicate special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            SpecialModelRenderer.Unbaked renderer = entry.right().get();
            if (renderer == null) {
                throw new RuntimeException("Got null special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            blocks.add(block);
            e.register(block, renderer);
        }
    }

    private Stream<ResourceLocation> modelConsumerLocations() {
        return this.modelConsumers.stream().map(Pair::left);
    }

    private void handleModelConsumers(Function<ResourceLocation, BakedModel> modelGetter) {
        for (Pair<ResourceLocation, Consumer<BakedModel>> entry : this.modelConsumers) {
            try {
                entry.right().accept(modelGetter.apply(entry.left()));
            }
            catch (Exception e) {
                CoreLib.LOGGER.error("Encountered an exception whilst applying a model consumer for mod '{}'!", (Object)this.modid, (Object)e);
            }
        }
    }

    private void handleRegisterItemModelsEvent(RegisterItemModelsEvent e) {
        this.itemModelTypes.forEach(p -> e.register((ResourceLocation)p.left(), (MapCodec)p.right()));
    }

    private void addSprites(ResourceLocation atlas, Consumer<ResourceLocation> spriteConsumer) {
        this.passedTextureStitch = true;
        Set<ResourceLocation> sprites = this.textureAtlasSprites.get(atlas);
        if (sprites == null) {
            return;
        }
        sprites.forEach(spriteConsumer);
    }
}

