/*
 * Decompiled with CFR 0.152.
 */
package com.jackbusters.wardenhorn;

import com.jackbusters.wardenhorn.FgLootTableAdder;
import com.jackbusters.wardenhorn.Registry;
import com.jackbusters.wardenhorn.SonicConfig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

@Mod(value="wardenhorn")
public class WardenHorn {
    public static final String MOD_ID = "wardenhorn";
    private final IEventBus eventBus;

    public WardenHorn(IEventBus eventBus, ModContainer modContainer) {
        this.eventBus = eventBus;
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SonicConfig.SPEC, "Warden-Horn-Server.toml");
        eventBus.addListener(this::addToCreativeTabsEvent);
        eventBus.addListener(this::register);
    }

    public void addToCreativeTabsEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.COMBAT)) {
            event.insertAfter(new ItemStack((ItemLike)Items.MACE), new ItemStack((ItemLike)Registry.wardenHorn.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.insertBefore(new ItemStack((ItemLike)Items.MUSIC_DISC_13), new ItemStack((ItemLike)Registry.wardenHorn.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public void register(NewRegistryEvent event) {
        Registry.ITEMS.register(this.eventBus);
        FgLootTableAdder.LOOT_MODIFIERS.register(this.eventBus);
    }
}

