/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.hud.render.TextureLocations;

public class CustomRenderTypes
extends RenderType {
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    private static final RenderStateShard.OutputStateShard KEEP_TARGET = new RenderStateShard.OutputStateShard("xaero_keep_target", () -> {}, () -> {});
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.TransparencyStateShard LINES_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_lines_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.TransparencyStateShard PREMULTIPLIED_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_wm_premultiplied_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    protected static final RenderStateShard.LayeringStateShard POLYGON_OFFSET_LAYERING = new RenderStateShard.LayeringStateShard("xaero_polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList<RenderStateShard> rendertype$state = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)layerPhases.texture).transparency(layerPhases.transparency).shader(layerPhases.shader).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).cull(layerPhases.cull).lightmap(LIGHTMAP).overlay(OVERLAY).target(KEEP_TARGET).build();
        return new MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, 256, true, true, rendertype$state);
    }

    private CustomRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderStateShard.TransparencyStateShard("xaero_custom_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderStateShard.TextureStateShard(texture, TriState.FALSE, false), TRANSLUCENT_TRANSPARENCY, LEQUAL_DEPTH_TEST, COLOR_DEPTH_WRITE, NO_CULL, RENDERTYPE_ENTITY_TRANSLUCENT_SHADER);
    }

    static {
        ImmutableList<RenderStateShard> multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.FALSE, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_NEAREST = new MultiPhaseRenderType("xaero_gui_nearest", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.TRUE, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_BILINEAR = new MultiPhaseRenderType("xaero_gui_bilinear", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.TRUE, false)).transparency(PREMULTIPLIED_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR_TEX)).cull(NO_CULL).target(KEEP_TARGET).build();
        GUI_BILINEAR_PREMULTIPLIED = new MultiPhaseRenderType("xaero_gui_bilinear_pre", POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        COLORED_WAYPOINTS_BGS = new MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        RADAR_NAME_BGS = new MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).build();
        MAP_CHUNK_OVERLAY = new MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(LINES_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.FRAMEBUFFER_LINES)).target(KEEP_TARGET).build();
        MAP_LINES = new MultiPhaseRenderType("xaero_lines", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(MinimapShaders.POSITION_COLOR_NO_ALPHA_TEST)).target(KEEP_TARGET).depthTest(GREATER_DEPTH_TEST).writeMaskState(DEPTH_WRITE).build();
        DEPTH_CLEAR = new MultiPhaseRenderType("xaero_depth_clear", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
    }

    static class MultiPhaseBuilder
    extends RenderStateShard {
        private RenderStateShard.EmptyTextureStateShard texture = RenderStateShard.NO_TEXTURE;
        private RenderStateShard.ShaderStateShard shader = RenderStateShard.NO_SHADER;
        private RenderStateShard.TransparencyStateShard transparency = RenderStateShard.NO_TRANSPARENCY;
        private RenderStateShard.DepthTestStateShard depthTest = RenderStateShard.LEQUAL_DEPTH_TEST;
        private RenderStateShard.CullStateShard cull = RenderStateShard.CULL;
        private RenderStateShard.LightmapStateShard lightmap = RenderStateShard.NO_LIGHTMAP;
        private RenderStateShard.OverlayStateShard overlay = RenderStateShard.NO_OVERLAY;
        private RenderStateShard.LayeringStateShard layering = RenderStateShard.NO_LAYERING;
        private RenderStateShard.OutputStateShard target = RenderStateShard.MAIN_TARGET;
        private RenderStateShard.TexturingStateShard texturing = RenderStateShard.DEFAULT_TEXTURING;
        private RenderStateShard.WriteMaskStateShard writeMaskState = RenderStateShard.COLOR_DEPTH_WRITE;
        private RenderStateShard.LineStateShard lineWidth = RenderStateShard.DEFAULT_LINE;

        MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderStateShard.EmptyTextureStateShard texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder shader(RenderStateShard.ShaderStateShard shader) {
            this.shader = shader;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderStateShard.TransparencyStateShard transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderStateShard.DepthTestStateShard depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderStateShard.CullStateShard cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderStateShard.LightmapStateShard lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderStateShard.OverlayStateShard overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder layering(RenderStateShard.LayeringStateShard layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderStateShard.OutputStateShard target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderStateShard.TexturingStateShard texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderStateShard.WriteMaskStateShard writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderStateShard.LineStateShard lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderStateShard> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.shader, (Object)this.transparency, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.layering, (Object)this.target, (Object)this.texturing, (Object)this.writeMaskState, (Object)this.lineWidth, (Object[])new RenderStateShard[0]);
        }

        public static void resetDepthTest() {
            RenderStateShard.EQUAL_DEPTH_TEST.setupRenderState();
            RenderStateShard.EQUAL_DEPTH_TEST.clearRenderState();
        }

        public static void resetWriteMask() {
            RenderStateShard.COLOR_WRITE.setupRenderState();
            RenderStateShard.COLOR_WRITE.clearRenderState();
            RenderStateShard.DEPTH_WRITE.setupRenderState();
            RenderStateShard.DEPTH_WRITE.clearRenderState();
        }

        public static void resetTransparency() {
            RenderStateShard.ADDITIVE_TRANSPARENCY.setupRenderState();
            RenderStateShard.ADDITIVE_TRANSPARENCY.clearRenderState();
        }
    }

    public static class EntityIconLayerPhases {
        public RenderStateShard.TextureStateShard texture;
        public RenderStateShard.TransparencyStateShard transparency;
        public RenderStateShard.DepthTestStateShard depthTest;
        public RenderStateShard.WriteMaskStateShard writeMask;
        public RenderStateShard.CullStateShard cull;
        public RenderStateShard.ShaderStateShard shader;

        public EntityIconLayerPhases(Object texture, Object transparency, Object depthTest, Object writeMask, Object cull, Object shader) {
            this.texture = (RenderStateShard.TextureStateShard)texture;
            this.transparency = (RenderStateShard.TransparencyStateShard)transparency;
            this.depthTest = (RenderStateShard.DepthTestStateShard)depthTest;
            this.writeMask = (RenderStateShard.WriteMaskStateShard)writeMask;
            this.cull = (RenderStateShard.CullStateShard)cull;
            this.shader = (RenderStateShard.ShaderStateShard)shader;
        }
    }

    private static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderStateShard> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderStateShard::setupRenderState), () -> phases.forEach(RenderStateShard::clearRenderState));
        }
    }
}

