/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.InfoDisplayManager;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final Component HELP_COMPONENT = Component.translatable((String)"gui.xaero_minimap_info_display_manager_help");
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private int subSelected;
    private final Map<String, MoveableEntry> moveableEntries;

    protected GuiInfoDisplayEdit(IXaeroMinimap modMain, Screen parent, Screen escape) {
        super(modMain, parent, escape, (Component)Component.translatable((String)"gui.xaero_minimap_info_display_manager"));
        this.manager = modMain.getMinimap().getInfoDisplays().getManager();
        this.currentOrder = new ArrayList<String>();
        this.manager.getOrderedStream().forEach(info -> this.currentOrder.add(info.getId()));
        this.moveableEntries = new HashMap<String, MoveableEntry>();
        this.selected = -1;
        this.subSelected = -1;
    }

    @Override
    protected void init() {
        super.init();
        this.selectionList = new SelectionList();
        this.addWidget(this.selectionList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done", (Object[])new Object[0]), b -> this.goBack()).bounds(this.width / 2 - 100, this.height - 34, 200, 20).build());
        this.moveableEntries.clear();
        for (String id : this.currentOrder) {
            InfoDisplay<?> infoDisplay = this.manager.get(id);
            MoveableEntry moveable = new MoveableEntry(this);
            this.addSubElements(moveable, infoDisplay);
            this.moveableEntries.put(id, moveable);
        }
    }

    public String[] createColorOptions(String symbol, boolean noneOption) {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (noneOption ? 1 : 0)];
        if (noneOption) {
            options[0] = "\u25a1\u25a1";
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (noneOption ? 1 : 0)] = "\u00a7" + ModSettings.ENCHANT_COLORS[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry moveable, InfoDisplay<T> infoDisplay) {
        AbstractWidget stateWidget = infoDisplay.createWidget(this.width / 2 + 150 - 102, 0, 100, 20);
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false)).setX(this.width / 2 - 147).setW(20).setSelected(infoDisplay.getTextColor() % ModSettings.ENCHANT_COLOR_NAMES.length).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setTextColor(index);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((Component)Component.translatable((String)"gui.xaero_dropdown_info_display_text_color")).build();
        moveable.addSubElement(textColorWidget);
        int currentBackgroundIndex = infoDisplay.getBackgroundColor();
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true)).setX(this.width / 2 - 124).setW(20).setSelected(currentBackgroundIndex < 0 ? 0 : currentBackgroundIndex % ModSettings.ENCHANT_COLOR_NAMES.length + 1).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setBackgroundColor(index - 1);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((Component)Component.translatable((String)"gui.xaero_dropdown_info_display_background_color")).build();
        moveable.addSubElement(backgroundColorWidget);
    }

    @Override
    public boolean mouseReleased(double d, double e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
        }
        return super.mouseReleased(d, e, i);
    }

    public void setFocused(GuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.selectionList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 5, -1);
        guiGraphics.drawCenteredString(this.font, HELP_COMPONENT, this.width / 2, this.height - 52, -1);
    }

    class SelectionList
    extends ObjectSelectionList<Entry> {
        private static final Component USAGE_NARRATION = Component.translatable((String)"narration.selection.usage");
        private static final Component LEFT_RIGHT_USAGE = Component.translatable((String)"narration.xaero_ui_list_left_right_usage");
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.minecraft, GuiInfoDisplayEdit.this.width, GuiInfoDisplayEdit.this.height - 61 - 30, 30, 24);
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setFocused((GuiEventListener)this.getEntry(GuiInfoDisplayEdit.this.selected));
            }
            this.dragged = -1;
        }

        public boolean isFocused() {
            return GuiInfoDisplayEdit.this.getFocused() == this;
        }

        public void setFocused(GuiEventListener guiEventListener) {
            if (guiEventListener instanceof Entry || guiEventListener == null) {
                Entry oldSelected;
                Entry entry = (Entry)guiEventListener;
                if (GuiInfoDisplayEdit.this.subSelected != -1 && (oldSelected = (Entry)this.getSelected()) != null) {
                    MoveableEntry moveable = oldSelected.getMoveable();
                    moveable.subElements.get(GuiInfoDisplayEdit.this.subSelected).setFocused(false);
                }
                GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
                GuiInfoDisplayEdit.this.subSelected = -1;
            }
            super.setFocused(guiEventListener);
            if (this.getFocused() == null) {
                this.setSelected((Entry)null);
            }
        }

        public void setSelected(Entry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            super.updateWidgetNarration(narrationElementOutput);
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, new Component[]{USAGE_NARRATION, LEFT_RIGHT_USAGE});
            }
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.manager.getCount(); ++i) {
                Entry entry = new Entry(i);
                this.addEntry((AbstractSelectionList.Entry)entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int scrollBarX() {
            return this.width / 2 + 164;
        }

        public int getRowWidth() {
            return 300;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = (Entry)this.getEntry(this.dragged);
                draggedEntry.renderNonInteractable(guiGraphics, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                Entry hoveredEntry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    GuiInfoDisplayEdit.this.manager.setOrder(GuiInfoDisplayEdit.this.currentOrder);
                    this.dragged = hoveredIndex;
                    try {
                        GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setFocused(null);
            }
        }

        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            FocusNavigationEvent.ArrowNavigation arrowNavigation;
            if (focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation && ((arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent).direction() == ScreenDirection.LEFT || arrowNavigation.direction() == ScreenDirection.RIGHT)) {
                return null;
            }
            return super.nextFocusPath(focusNavigationEvent);
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;
            private int lastMouseX;
            private int lastMouseY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(GuiGraphics guiGraphics, int x, int y) {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                guiGraphics.drawString(GuiInfoDisplayEdit.this.font, infoDisplay.getName(), x + 48, y + 6, -1);
            }

            private MoveableEntry getMoveable() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void render(GuiGraphics guiGraphics, int index, int y, int x, int l, int m, int mouseX, int mouseY, boolean bl, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(guiGraphics, x, y);
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    subElement.setY(y - 2 + 12 - subElement.getHeight() / 2);
                    if (subElement instanceof DropDownWidget) {
                        subElement.setY(subElement.getY() - 1);
                    }
                    subElement.render(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean mouseClicked(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseClicked(d, e, i)) continue;
                    return true;
                }
                if (i == 0) {
                    SelectionList.this.dragging = false;
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                    if (SelectionList.this.getSelected() != this) return true;
                    SelectionList.this.setFocused(null);
                    return super.mouseClicked(d, e, i);
                } else {
                    SelectionList.this.setFocused(null);
                }
                return super.mouseClicked(d, e, i);
            }

            public boolean mouseReleased(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    subElement.mouseReleased(d, e, i);
                }
                return super.mouseReleased(d, e, i);
            }

            public void mouseMoved(double d, double e) {
                this.lastMouseX = (int)d;
                this.lastMouseY = (int)e;
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.isMouseOver(d, e)) continue;
                    subElement.mouseMoved(d, e);
                }
                super.mouseMoved(d, e);
            }

            public boolean mouseDragged(double d, double e, int i, double f, double g) {
                this.lastMouseX = (int)d;
                this.lastMouseY = (int)e;
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseDragged(d, e, i, f, g)) continue;
                    return true;
                }
                return super.mouseDragged(d, e, i, f, g);
            }

            public boolean mouseScrolled(double d, double e, double f, double g) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.isMouseOver(d, e) || !subElement.mouseScrolled(d, e, f, g)) continue;
                    return true;
                }
                return super.mouseScrolled(d, e, f, g);
            }

            public boolean keyPressed(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (i == 262 || i == 263) {
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).setFocused(false);
                    }
                    if (i == 262) {
                        ++GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected == moveableEntry.subElements.size()) {
                            GuiInfoDisplayEdit.this.subSelected = -1;
                        }
                    } else {
                        --GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected < -1) {
                            GuiInfoDisplayEdit.this.subSelected = moveableEntry.subElements.size() - 1;
                        }
                    }
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).setFocused(true);
                    }
                } else if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).keyPressed(i, j, k)) {
                    return true;
                }
                return super.keyPressed(i, j, k);
            }

            public boolean keyReleased(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).keyReleased(i, j, k)) {
                    return true;
                }
                return super.keyReleased(i, j, k);
            }

            public boolean charTyped(char c, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).charTyped(c, i)) {
                    return true;
                }
                return super.charTyped(c, i);
            }

            public void updateNarration(NarrationElementOutput narrationElementOutput) {
                MoveableEntry moveableEntry = this.getMoveable();
                int sub = -1;
                if (GuiInfoDisplayEdit.this.selected == this.index && GuiInfoDisplayEdit.this.subSelected >= 0) {
                    sub = GuiInfoDisplayEdit.this.subSelected;
                } else {
                    for (int i = 0; i < moveableEntry.subElements.size(); ++i) {
                        if (!moveableEntry.subElements.get(i).isMouseOver((double)this.lastMouseX, (double)this.lastMouseY)) continue;
                        sub = i;
                    }
                }
                if (sub >= 0) {
                    moveableEntry.subElements.get(sub).updateNarration(narrationElementOutput);
                } else {
                    super.updateNarration(narrationElementOutput);
                }
            }

            public Component getNarration() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                String narration = infoDisplay.getName().getString();
                return Component.literal((String)I18n.get((String)"narrator.select", (Object[])new Object[]{narration}));
            }
        }
    }

    class MoveableEntry {
        private final List<AbstractWidget> subElements = new ArrayList<AbstractWidget>();

        public MoveableEntry(GuiInfoDisplayEdit this$0) {
        }

        public void addSubElement(AbstractWidget widget) {
            this.subElements.add(widget);
        }
    }
}

