/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.item;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ArchitecturySpawnEggItem
extends SpawnEggItem {
    private static final Logger LOGGER = LogManager.getLogger(ArchitecturySpawnEggItem.class);
    private final RegistrySupplier<? extends EntityType<? extends Mob>> entityType;

    protected static DispenseItemBehavior createDispenseItemBehavior() {
        return new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                EntityType entityType = ((SpawnEggItem)stack.getItem()).getType((HolderLookup.Provider)source.level().registryAccess(), stack);
                try {
                    entityType.spawn(source.level(), stack, null, source.pos().relative(direction), EntitySpawnReason.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception var6) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.pos(), (Object)var6);
                    return ItemStack.EMPTY;
                }
                stack.shrink(1);
                source.level().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, source.pos());
                return stack;
            }
        };
    }

    public ArchitecturySpawnEggItem(RegistrySupplier<? extends EntityType<? extends Mob>> entityType, Item.Properties properties) {
        this(entityType, properties, ArchitecturySpawnEggItem.createDispenseItemBehavior());
    }

    public ArchitecturySpawnEggItem(RegistrySupplier<? extends EntityType<? extends Mob>> entityType, Item.Properties properties, @Nullable DispenseItemBehavior dispenseItemBehavior) {
        super(null, properties);
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        SpawnEggItem.BY_ID.remove(null);
        entityType.listen(type -> {
            LOGGER.debug("Registering spawn egg {} for {}", (Object)this.toString(), (Object)Objects.toString(type.arch$registryName()));
            SpawnEggItem.BY_ID.put(type, this);
            this.defaultType = type;
            if (dispenseItemBehavior != null) {
                DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)dispenseItemBehavior);
            }
        });
    }

    public EntityType<?> getType(HolderLookup.Provider provider, ItemStack itemStack) {
        EntityType type = super.getType(provider, itemStack);
        return type == null ? (EntityType)this.entityType.get() : type;
    }
}

