/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.client.rendering.forge;

import com.google.common.collect.Lists;
import dev.architectury.platform.hooks.EventBusesHooks;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ColorHandlerRegistryImpl {
    private static final List<Pair<BlockColor, Supplier<? extends Block>[]>> BLOCK_COLORS = Lists.newArrayList();

    @SubscribeEvent
    public static void onBlockColorEvent(RegisterColorHandlersEvent.Block event) {
        for (Pair<BlockColor, Supplier<? extends Block>[]> pair : BLOCK_COLORS) {
            event.register((BlockColor)pair.getLeft(), ColorHandlerRegistryImpl.unpackBlocks((Supplier[])pair.getRight()));
        }
    }

    @SafeVarargs
    public static void registerBlockColors(BlockColor blockColor, Supplier<? extends Block> ... blocks) {
        Objects.requireNonNull(blockColor, "color is null!");
        if (Minecraft.getInstance().getBlockColors() == null) {
            BLOCK_COLORS.add((Pair<BlockColor, Supplier<? extends Block>[]>)Pair.of((Object)blockColor, blocks));
        } else {
            Minecraft.getInstance().getBlockColors().register(blockColor, ColorHandlerRegistryImpl.unpackBlocks(blocks));
        }
    }

    private static Block[] unpackBlocks(Supplier<? extends Block>[] blocks) {
        Block[] array = new Block[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            array[i] = Objects.requireNonNull(blocks[i].get());
        }
        return array;
    }

    static {
        EventBusesHooks.whenAvailable("architectury", bus -> bus.register(ColorHandlerRegistryImpl.class));
    }
}

