/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.config.ClientConfigContext;
import lol.bai.badpackets.api.config.ServerConfigContext;
import lol.bai.badpackets.api.play.ClientPlayContext;
import lol.bai.badpackets.api.play.ServerPlayContext;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.payload.UntypedPayload;
import lol.bai.badpackets.impl.registry.ChannelCodecFinder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ChannelRegistry<B extends FriendlyByteBuf, C>
implements ChannelCodecFinder {
    private static final Set<ResourceLocation> RESERVED_CHANNELS = Set.of(Constants.CHANNEL_SYNC, Constants.MC_REGISTER_CHANNEL, Constants.MC_UNREGISTER_CHANNEL);
    public static final ChannelRegistry<FriendlyByteBuf, ClientConfigContext> CONFIG_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<FriendlyByteBuf, ServerConfigContext> CONFIG_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<RegistryFriendlyByteBuf, ClientPlayContext> PLAY_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<RegistryFriendlyByteBuf, ServerPlayContext> PLAY_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    private final Set<ResourceLocation> reservedChannels;
    private final Map<ResourceLocation, StreamCodec<?, ?>> codecs = new HashMap();
    private final Map<ResourceLocation, PacketReceiver<C, CustomPacketPayload>> receivers = new HashMap<ResourceLocation, PacketReceiver<C, CustomPacketPayload>>();
    private final Set<AbstractPacketHandler<C, B>> handlers = new HashSet<AbstractPacketHandler<C, B>>();
    private final ReentrantReadWriteLock locks = new ReentrantReadWriteLock();

    private ChannelRegistry(Set<ResourceLocation> reservedChannels) {
        this.reservedChannels = reservedChannels;
        this.codecs.put(Constants.CHANNEL_SYNC, UntypedPayload.codec(Constants.CHANNEL_SYNC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends CustomPacketPayload> void registerCodec(ResourceLocation id, StreamCodec<? super B, P> codec) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (this.reservedChannels.contains(id)) {
                throw new IllegalArgumentException("Reserved channel id " + String.valueOf(id));
            }
            this.codecs.put(id, codec);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReceiver(ResourceLocation id, PacketReceiver<C, CustomPacketPayload> receiver) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (!this.codecs.containsKey(id)) {
                throw new IllegalArgumentException("Unknown channel id " + String.valueOf(id));
            }
            this.receivers.put(id, receiver);
            for (AbstractPacketHandler<C, B> handler : this.handlers) {
                handler.onRegister(id);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(ResourceLocation id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            boolean bl = this.receivers.containsKey(id);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReceiver<C, CustomPacketPayload> get(ResourceLocation id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            PacketReceiver<C, CustomPacketPayload> packetReceiver = this.receivers.get(id);
            return packetReceiver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StreamCodec<FriendlyByteBuf, CustomPacketPayload> getCodec(ResourceLocation id, FriendlyByteBuf buf) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            StreamCodec<?, ?> streamCodec = this.codecs.get(id);
            return streamCodec;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<ResourceLocation> getChannels() {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            HashSet<ResourceLocation> hashSet = new HashSet<ResourceLocation>(this.receivers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void addHandler(AbstractPacketHandler<C, B> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.add(handler);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeHandler(AbstractPacketHandler<C, B> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.remove(handler);
        }
        finally {
            lock.unlock();
        }
    }
}

