/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.builtinpacks.BuiltInPack;
import de.cristelknight.cristellib.builtinpacks.BuiltinResourcePackSource;
import de.cristelknight.cristellib.data.BuiltInPackConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.NotNull;

public class BuiltInDataPackLoader {
    private static final List<BuiltInPack> PACK_LIST = new ArrayList<BuiltInPack>();
    private static boolean frozen = false;

    public static void registerAlwaysOnPack(ResourceLocation path, Component displayName) {
        BuiltInDataPackLoader.registerPack(path, displayName, () -> true);
    }

    public static void registerPack(ResourceLocation path, Component displayName, Supplier<Boolean> supplier) {
        BuiltInDataPackLoader.registerPack(CristelLibExpectPlatform.registerBuiltinResourcePack(path, displayName), displayName, supplier);
    }

    public static void registerPack(PackResources packResource, Component displayName, Supplier<Boolean> supplier) {
        if (frozen) {
            throw new RuntimeException(CristelLib.getWithPrefix(String.format("BuiltInDataPack Registry is already frozen. Cannot add Pack with id: %s", packResource.packId())));
        }
        PACK_LIST.add(new BuiltInPack(packResource, displayName, supplier));
    }

    public static List<String> getIDs() {
        return PACK_LIST.stream().map(pack -> pack.packResource().packId()).filter(id -> !id.equals(CristelLib.CRISTEL_LIB_PACK_RL.toString())).toList();
    }

    public static void getPacks(Consumer<Pack> consumer) {
        if (!frozen) {
            throw new RuntimeException(CristelLib.getWithPrefix("Tried to load Packs before the Registry phase is over!"));
        }
        if (PACK_LIST.isEmpty()) {
            return;
        }
        BuiltInPackConfig config = (BuiltInPackConfig)BuiltInPackConfig.DEFAULT.getConfig();
        for (BuiltInPack entry : PACK_LIST) {
            PackSelectionConfig info2;
            final PackResources pack = entry.packResource();
            if (!entry.supplier().get().booleanValue() || config.disabledPacks().contains(pack.packId()) || pack.getNamespaces(PackType.SERVER_DATA).isEmpty()) continue;
            Component displayName = entry.displayName();
            PackLocationInfo metadata = new PackLocationInfo(pack.packId(), displayName, (PackSource)new BuiltinResourcePackSource(), pack.knownPackInfo());
            Pack profile = Pack.readMetaAndCreate((PackLocationInfo)metadata, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                @NotNull
                public PackResources openPrimary(PackLocationInfo var1) {
                    return pack;
                }

                @NotNull
                public PackResources openFull(PackLocationInfo var1, Pack.Metadata metadata) {
                    return pack;
                }
            }, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)(info2 = new PackSelectionConfig(true, Pack.Position.TOP, false)));
            if (profile == null) {
                CristelLib.LOGGER.error("Pack Profile with display name: {} is null", (Object)displayName);
                continue;
            }
            consumer.accept(profile);
        }
    }

    public static void freeze() {
        frozen = true;
    }
}

