/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.data.StructureSetHolder;
import de.cristelknight.cristellib.util.JanksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ReadStructureSets {
    public static Map<ResourceLocation, List<String>> readSetsAndAddStructures(List<StructureSetHolder> structureSetHolder) {
        HashMap<ResourceLocation, List<String>> structures = new HashMap<ResourceLocation, List<String>>();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonArray structureArray = GsonHelper.getAsJsonArray((JsonObject)e.getAsJsonObject(), (String)"structures");
            ArrayList<String> structureList = new ArrayList<String>();
            for (JsonElement element : structureArray) {
                if (!element.isJsonObject()) continue;
                structureList.add(GsonHelper.getAsString((JsonObject)element.getAsJsonObject(), (String)"structure"));
            }
            structures.put((ResourceLocation)setLocation, (List<String>)structureList);
        }));
        return structures;
    }

    public static Map<String, PlacementConfig> readSetsAndAddPlacements(List<StructureSetHolder> structureSetHolder) {
        HashMap<String, PlacementConfig> structurePlacement = new HashMap<String, PlacementConfig>();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonObject placement = GsonHelper.getAsJsonObject((JsonObject)e.getAsJsonObject(), (String)"placement");
            PlacementConfig config = ConfigManager.readElement(String.format("Couldn't read %s in %s, crashing instead. Maybe try to delete the config files!", setLocation, modID), PlacementConfig.CODEC, JsonOps.INSTANCE, placement);
            structurePlacement.put(setLocation.getPath(), config);
        }));
        return structurePlacement;
    }

    private static boolean checkElement(JsonElement element, String modID, ResourceLocation setLocation) {
        if (!element.isJsonObject()) {
            CristelLib.LOGGER.error("Set for {} {} is not a JsonObject", (Object)modID, (Object)setLocation);
            return true;
        }
        return false;
    }
}

