/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import org.cyclops.cyclopscore.helper.IModHelpers;

public abstract class DynamicBaseModel
implements BakedModel {
    protected static final float[][] ROTATION_UV = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}};
    protected static final int[] ROTATION_FIX = new int[]{2, 0, 2, 0, 1, 3};
    protected static final float[][] UVS = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    protected static Vec3 rotate(Vec3 vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.x, -vec.y, -vec.z);
            }
            case UP: {
                return new Vec3(vec.x, vec.y, vec.z);
            }
            case NORTH: {
                return new Vec3(vec.x, vec.z, -vec.y);
            }
            case SOUTH: {
                return new Vec3(vec.x, -vec.z, vec.y);
            }
            case WEST: {
                return new Vec3(-vec.y, vec.x, vec.z);
            }
            case EAST: {
                return new Vec3(vec.y, -vec.x, vec.z);
            }
        }
        return vec;
    }

    protected static Vec3 revRotate(Vec3 vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.x, -vec.y, -vec.z);
            }
            case UP: {
                return new Vec3(vec.x, vec.y, vec.z);
            }
            case NORTH: {
                return new Vec3(vec.x, -vec.z, vec.y);
            }
            case SOUTH: {
                return new Vec3(vec.x, vec.z, -vec.y);
            }
            case WEST: {
                return new Vec3(vec.y, -vec.x, vec.z);
            }
            case EAST: {
                return new Vec3(-vec.y, vec.x, vec.z);
            }
        }
        return vec;
    }

    protected static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.getU(u / 16.0f)), Float.floatToRawIntBits(texture.getV(v / 16.0f)), 0, 0};
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, -1, side);
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, false);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Color shadeColor, Direction side) {
        int color = IModHelpers.get().getBaseHelpers().RGBAToInt(shadeColor.getBlue(), shadeColor.getGreen(), shadeColor.getRed(), shadeColor.getAlpha());
        DynamicBaseModel.addColoredBakedQuad(quads, x1, x2, z1, z2, y, texture, color, side);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, true);
    }

    private static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side, boolean isColored) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, 0, isColored, shadeColor, new float[][]{{x1, z1}, {x1, z2}, {x2, z2}, {x2, z1}});
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, rotation, false, -1, ROTATION_UV);
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation, boolean isColored, int shadeColor, float[][] uvs) {
        Vec3 v1 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).add(0.5, 0.5, 0.5);
        Vec3 v2 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).add(0.5, 0.5, 0.5);
        Vec3 v3 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).add(0.5, 0.5, 0.5);
        Vec3 v4 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).add(0.5, 0.5, 0.5);
        int[] data = Ints.concat((int[][])new int[][]{DynamicBaseModel.vertexToInts((float)v1.x, (float)v1.y, (float)v1.z, shadeColor, texture, uvs[(0 + rotation) % 4][0] * 16.0f, uvs[(0 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v2.x, (float)v2.y, (float)v2.z, shadeColor, texture, uvs[(1 + rotation) % 4][0] * 16.0f, uvs[(1 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v3.x, (float)v3.y, (float)v3.z, shadeColor, texture, uvs[(2 + rotation) % 4][0] * 16.0f, uvs[(2 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v4.x, (float)v4.y, (float)v4.z, shadeColor, texture, uvs[(3 + rotation) % 4][0] * 16.0f, uvs[(3 + rotation) % 4][1] * 16.0f)});
        ClientHooks.fillNormal((int[])data, (Direction)side);
        quads.add(new BakedQuad(data, -1, side, texture, false, shadeColor));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return Collections.emptyList();
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }
}

