/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

@EventBusSubscriber(modid="cyclopscore", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ItemActionNeoForge<M extends ModBaseNeoForge<M>>
extends ItemAction<M> {
    @Override
    protected void polish(ItemConfigCommon<M> config) {
        IDynamicModelElementCommon dynamicModelElement;
        super.polish(config);
        if (((ModBaseNeoForge)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide() && (dynamicModelElement = config.getItemClientConfig().getDynamicModelElement()) != null) {
            ItemAction.handleItemModel(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            config.getItemClientConfig().dynamicItemVariantLocation = config.getItemClientConfig().registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            IDynamicModelElementCommon dynamicModelElement = config.getItemClientConfig().getDynamicModelElement();
            if (config.getItemClientConfig().dynamicItemVariantLocation == null) continue;
            event.getBakingResult().blockStateModels().put(config.getItemClientConfig().dynamicItemVariantLocation, dynamicModelElement.createDynamicModel(pair -> event.getBakingResult().blockStateModels().put((ModelResourceLocation)pair.getLeft(), (BakedModel)pair.getRight()), key -> (BakedModel)event.getBakingResult().blockStateModels().get(key)));
        }
    }
}

