/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SingleUseTank
extends Tank {
    public static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private Fluid acceptedFluid;

    public SingleUseTank(int capacity) {
        super(capacity);
        this.setAcceptedFluid(Fluids.EMPTY);
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        Fluid acceptedFluid = this.getAcceptedFluid();
        int filled = 0;
        if (resource.isEmpty()) {
            filled = 0;
        } else {
            if (action.execute() && acceptedFluid == Fluids.EMPTY) {
                acceptedFluid = resource.getFluid();
            }
            if (acceptedFluid == Fluids.EMPTY || acceptedFluid == resource.getFluid()) {
                filled = super.fill(resource, action);
            }
        }
        if (action.execute() && filled > 0) {
            this.sendUpdate();
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (action.execute() && !drained.isEmpty()) {
            this.sendUpdate();
        }
        return drained;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (action.execute() && !drained.isEmpty()) {
            this.sendUpdate();
        }
        return drained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUpdate() {
        LinkedList dirtyMarkListeners;
        SingleUseTank singleUseTank = this;
        synchronized (singleUseTank) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    public void reset() {
        this.acceptedFluid = Fluids.EMPTY;
        this.setValidator(fluidStack -> true);
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = Objects.requireNonNull(fluid);
        if (fluid == Fluids.EMPTY) {
            this.setValidator(fluidStack -> true);
        } else {
            this.setValidator(fluidStack -> fluidStack.getFluid() == fluid);
        }
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(CompoundTag nbt) {
        super.writeTankToNBT(nbt);
        nbt.putString(NBT_ACCEPTED_FLUID, BuiltInRegistries.FLUID.getKey((Object)this.acceptedFluid).toString());
    }

    @Override
    public void readTankFromNBT(CompoundTag nbt) {
        super.readTankFromNBT(nbt);
        this.setAcceptedFluid((Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.parse((String)nbt.getString(NBT_ACCEPTED_FLUID))));
    }
}

