/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.GuiHelpersCommon;
import org.cyclops.cyclopscore.helper.IGuiHelpersNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.lwjgl.opengl.GL11;

public class GuiHelpersNeoForge
extends GuiHelpersCommon
implements IGuiHelpersNeoForge {
    public GuiHelpersNeoForge(IModHelpers modHelpers) {
        super(modHelpers);
    }

    @Override
    public void renderFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height) {
        if (fluidStack != null && !fluidStack.isEmpty() && capacity > 0) {
            gui.pose().pushPose();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            Lighting.setupFor3DItems();
            GL11.glEnable((int)2929);
            int level = (int)((double)height * ((double)fluidStack.getAmount() / (double)capacity));
            TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluidStack, Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((FluidType)fluidStack.getFluid().getFluidType());
                Triple colorParts = IModHelpers.get().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluidStack));
                if (fluidStack.getFluid() == Fluids.WATER || fluidStack.getFluid() == Fluids.FLOWING_WATER) {
                    colorParts = Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.335f), (Object)Float.valueOf(1.0f));
                }
                Lighting.setupForFlatItems();
                RenderSystem.setShaderColor((float)((Float)colorParts.getLeft()).floatValue(), (float)((Float)colorParts.getMiddle()).floatValue(), (float)((Float)colorParts.getRight()).floatValue(), (float)1.0f);
                gui.blitSprite(RenderType::guiTextured, icon, x, y - textureHeight - verticalOffset + height, width, textureHeight);
                gui.flush();
                Lighting.setupFor3DItems();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                verticalOffset += 16;
            }
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            textureManager.getTexture(TextureAtlas.LOCATION_BLOCKS).restoreLastBlurMipmap();
            Lighting.setupForFlatItems();
            gui.pose().popPose();
            GL11.glDisable((int)2929);
        }
    }

    @Override
    public void renderFluidSlot(GuiGraphics gui, @Nullable FluidStack fluidStack, int x, int y) {
        if (fluidStack != null) {
            IModHelpersNeoForge.get().getGuiHelpers().renderFluidTank(gui, fluidStack, fluidStack.getAmount(), x, y, this.getSlotSizeInner(), this.getSlotSizeInner());
        }
    }

    @Override
    public void renderOverlayedFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height, ResourceLocation textureOverlay, int overlayTextureX, int overlayTextureY) {
        this.renderFluidTank(gui, fluidStack, capacity, x, y, width, height);
        if (fluidStack != null && capacity > 0) {
            GlStateManager._enableBlend();
            gui.blit(RenderType::guiTextured, textureOverlay, x, y, (float)overlayTextureX, (float)overlayTextureY, width, height, 256, 256);
        }
    }
}

