/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class FurnaceRecipeAppendix
extends RecipeAppendix<SmeltingRecipe> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 3;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT = AdvancedButtonEnum.create();

    public FurnaceRecipeAppendix(IInfoBook infoBook, Supplier<RecipeDisplayEntry> recipeDisplay) {
        super(infoBook, recipeDisplay);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 22;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "block.minecraft.furnace";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(guiGraphics, x + middle - 3, y + 3 + 2);
        RecipeDisplayEntry recipeDisplay = this.getRecipeDisplay();
        if (recipeDisplay == null) {
            return;
        }
        int tick = this.getTick(gui);
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
        ItemStack input = this.prepareItemStacks(((FurnaceRecipeDisplay)recipeDisplay.display()).ingredient().resolveForStacks(contextMap), tick);
        ItemStack result = this.prepareItemStacks(recipeDisplay.display().result().resolveForStacks(contextMap), tick);
        this.renderItem(gui, guiGraphics, x + 16, y + 3, input, mx, my, INPUT);
        this.renderItem(gui, guiGraphics, x + 68, y + 3, result, mx, my, RESULT);
        this.renderItem(gui, guiGraphics, x + middle, y + 3, new ItemStack((ItemLike)Blocks.FURNACE), mx, my, false, null);
    }
}

