/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;

public abstract class SectionAppendix {
    private final IInfoBook infoBook;
    private int page;
    private int lineStart;

    public SectionAppendix(IInfoBook infoBook) {
        this.infoBook = infoBook;
    }

    public int getFullHeight() {
        return this.getHeight() + this.getOffsetY() * 2;
    }

    protected abstract int getOffsetY();

    protected abstract int getWidth();

    protected abstract int getHeight();

    @OnlyIn(value=Dist.CLIENT)
    public void drawScreen(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my, boolean pre) {
        int xc = x + width / 2 - this.getWidth() / 2;
        int yc = y + this.getOffsetY();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        if (pre) {
            this.drawElement(gui, guiGraphics, xc, yc, this.getWidth(), this.getHeight(), page, mx, my);
        } else {
            this.postDrawElement(gui, guiGraphics, xc, yc, this.getWidth(), this.getHeight(), page, mx, my);
        }
        GlStateManager._disableBlend();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawElement(ScreenInfoBook var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void postDrawElement(ScreenInfoBook var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void preBakeElement(InfoSection var1);

    public abstract void bakeElement(InfoSection var1);

    public IInfoBook getInfoBook() {
        return this.infoBook;
    }

    public int getPage() {
        return this.page;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setLineStart(int lineStart) {
        this.lineStart = lineStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SectionAppendix)) {
            return false;
        }
        SectionAppendix other = (SectionAppendix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IInfoBook this$infoBook = this.getInfoBook();
        IInfoBook other$infoBook = other.getInfoBook();
        if (this$infoBook == null ? other$infoBook != null : !this$infoBook.equals(other$infoBook)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getLineStart() == other.getLineStart();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SectionAppendix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IInfoBook $infoBook = this.getInfoBook();
        result = result * 59 + ($infoBook == null ? 43 : $infoBook.hashCode());
        result = result * 59 + this.getPage();
        result = result * 59 + this.getLineStart();
        return result;
    }

    public String toString() {
        return "SectionAppendix(infoBook=" + String.valueOf(this.getInfoBook()) + ", page=" + this.getPage() + ", lineStart=" + this.getLineStart() + ")";
    }
}

