/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;

public abstract class DamageIndicatedItemFluidContainer
extends Item
implements IInformationProvider {
    protected final int capacity;
    protected DamageIndicatedItemComponent component;
    protected final Supplier<Fluid> fluid;

    public DamageIndicatedItemFluidContainer(Item.Properties builder, int capacity, Supplier<Fluid> fluid) {
        super(builder);
        this.capacity = capacity;
        this.fluid = fluid;
        this.init();
        CyclopsCoreNeoForge._instance.getModEventBus().addListener(this::registerCapability);
    }

    private void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (itemStack, context) -> new FluidHandlerItemCapacity((ItemStack)itemStack, this.capacity, this.getFluid()), new ItemLike[]{this});
        event.registerItem(Capabilities.Item.FLUID_HANDLER_CAPACITY, (itemStack, context) -> new FluidHandlerItemCapacity((ItemStack)itemStack, this.capacity, this.getFluid()), new ItemLike[]{this});
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        this.component.fillDefaultCreativeTabEntries((NonNullList<ItemStack>)list, this.fluid.get());
        return list;
    }

    @Override
    public MutableComponent getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        this.component.addInformation(itemStack, context, list, flag);
        super.appendHoverText(itemStack, context, list, flag);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack simulatedDrain = fluidHandler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        return simulatedDrain != null && simulatedDrain.getAmount() == amount;
    }
}

