/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class AdvancementRewardsObtainPacket
extends PacketCodec<AdvancementRewardsObtainPacket> {
    public static final CustomPacketPayload.Type<AdvancementRewardsObtainPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"advancement_rewards_obtain_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvancementRewardsObtainPacket> CODEC = AdvancementRewardsObtainPacket.getCodec(AdvancementRewardsObtainPacket::new);
    @CodecField
    private String advancementRewardsId;

    public AdvancementRewardsObtainPacket() {
        super(TYPE);
    }

    public AdvancementRewardsObtainPacket(String advancementRewardsId) {
        this();
        this.advancementRewardsId = advancementRewardsId;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level level, Player player) {
    }

    @Override
    public void actionServer(net.minecraft.world.level.Level level, ServerPlayer player) {
        AdvancementRewards advancementRewards = AdvancementRewards.getAdvancementRewards(this.advancementRewardsId);
        if (advancementRewards != null) {
            advancementRewards.obtain((Player)player);
        } else {
            CyclopsCoreNeoForge.clog(Level.WARN, String.format("Received an invalid advancement reward id '%s' from %s.", this.advancementRewardsId, player.getDisplayName().getString()));
        }
    }
}

