/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.RecipeHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class SendRecipeDisplayPacket
extends PacketCodec<SendRecipeDisplayPacket> {
    public static final CustomPacketPayload.Type<SendRecipeDisplayPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"send_recipe_display_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendRecipeDisplayPacket> CODEC = SendRecipeDisplayPacket.getCodec(SendRecipeDisplayPacket::new);
    @CodecField
    private String recipeType;
    @CodecField
    private String recipe;
    private RecipeDisplayEntry recipeDisplay;

    public SendRecipeDisplayPacket() {
        super(TYPE);
    }

    public SendRecipeDisplayPacket(String recipeType, String recipe, RecipeDisplayEntry recipeDisplay) {
        this();
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeDisplay = recipeDisplay;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf output) {
        super.encode(output);
        RecipeDisplayEntry.STREAM_CODEC.encode((Object)output, (Object)this.recipeDisplay);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf input) {
        super.decode(input);
        this.recipeDisplay = (RecipeDisplayEntry)RecipeDisplayEntry.STREAM_CODEC.decode((Object)input);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level level, Player player) {
        RecipeHelpers.setRecipeDisplay((RecipeType)BuiltInRegistries.RECIPE_TYPE.getValue(ResourceLocation.parse((String)this.recipeType)), ResourceLocation.parse((String)this.recipe), this.recipeDisplay);
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
    }
}

