/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class RecipeCraftingShapelessCustomOutput
extends ShapelessRecipe {
    private final Serializer serializer;
    private final ItemStack recipeOutput;

    public RecipeCraftingShapelessCustomOutput(Serializer serializer, String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, List<Ingredient> recipeItemsIn) {
        super(groupIn, category, recipeOutputIn, recipeItemsIn);
        this.serializer = serializer;
        this.recipeOutput = recipeOutputIn;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public RecipeSerializer<ShapelessRecipe> getSerializer() {
        return this.serializer;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        Serializer.IOutputTransformer outputTransformer = this.serializer.getOutputTransformer();
        if (outputTransformer != null) {
            return outputTransformer.transform(inv, this.getResultItem());
        }
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCraftingShapelessCustomOutput> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crafting_shapeless");
        private final Supplier<ItemStack> outputProvider;
        @Nullable
        private final IOutputTransformer outputTransformer;
        private final MapCodec<RecipeCraftingShapelessCustomOutput> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapelessCustomOutput> streamCodec;

        public Serializer(Supplier<ItemStack> outputProvider, @Nullable IOutputTransformer outputTransformer) {
            this.outputProvider = outputProvider;
            this.outputTransformer = outputTransformer;
            this.codec = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())).fieldOf("ingredients").forGetter(p_360071_ -> p_360071_.placementInfo().ingredients())).apply((Applicative)p_311734_, (group, category, ingredients) -> new RecipeCraftingShapelessCustomOutput(this, (String)group, (CraftingBookCategory)category, this.outputProvider.get(), (List<Ingredient>)ingredients)));
            this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p_360074_ -> p_360074_.group(), (StreamCodec)CraftingBookCategory.STREAM_CODEC, p_360073_ -> p_360073_.category(), (StreamCodec)ItemStack.STREAM_CODEC, p_360070_ -> p_360070_.getResultItem(), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), p_360069_ -> p_360069_.placementInfo().ingredients(), (group, category, result, ingredients) -> new RecipeCraftingShapelessCustomOutput(this, (String)group, (CraftingBookCategory)category, this.outputProvider.get(), (List<Ingredient>)ingredients));
        }

        public Serializer(Supplier<ItemStack> outputProvider) {
            this(outputProvider, null);
        }

        @Nullable
        public IOutputTransformer getOutputTransformer() {
            return this.outputTransformer;
        }

        public MapCodec<RecipeCraftingShapelessCustomOutput> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapelessCustomOutput> streamCodec() {
            return this.streamCodec;
        }

        public static interface IOutputTransformer {
            public ItemStack transform(CraftingInput var1, ItemStack var2);
        }
    }
}

