/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.data.provider.DEAdvancementProvider;
import com.barion.dungeons_enhanced.data.provider.DEBiomeTagsProvider;
import com.barion.dungeons_enhanced.data.provider.DELootTableProvider;
import com.barion.dungeons_enhanced.data.provider.DEStructureTagsProvider;
import com.barion.dungeons_enhanced.registry.DEJigsawTypes;
import com.barion.dungeons_enhanced.registry.DELootTableAliases;
import com.barion.dungeons_enhanced.registry.DEProcessorLists;
import com.barion.dungeons_enhanced.registry.DETemplatePools;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="dungeons_enhanced")
public final class DungeonsEnhanced {
    public static final String MOD_ID = "dungeons_enhanced";

    public DungeonsEnhanced(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(DungeonsEnhanced::gatherData);
        RegistrarHandler.registerHandlers((String)MOD_ID, (IEventBus)modEventBus, (RegistrarHandler[])new RegistrarHandler[]{DETemplatePools.HANDLER, DEProcessorLists.HANDLER, DEJigsawTypes.HANDLER, DELootTableAliases.HANDLER});
    }

    public static void gatherData(GatherDataEvent.Server event) {
        PackOutput output = event.getGenerator().getPackOutput();
        DatapackBuiltinEntriesProvider registrarProvider = new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), RegistrarHandler.injectRegistries((RegistrySetBuilder)new RegistrySetBuilder()), Set.of(MOD_ID));
        CompletableFuture lookup = registrarProvider.getRegistryProvider();
        event.addProvider((DataProvider)registrarProvider);
        event.createProvider(DEBiomeTagsProvider::new);
        event.createProvider(DELootTableProvider::new);
        event.addProvider((DataProvider)new DEAdvancementProvider(output, lookup));
        event.addProvider((DataProvider)new DEStructureTagsProvider(output, lookup));
    }

    public static ResourceLocation locate(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

