/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.data.provider;

import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public final class DEAdvancementProvider
extends AdvancementProvider {
    public DEAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, List.of(new DEExplorerAdvancementSubProvider()));
    }

    public static final class DEExplorerAdvancementSubProvider
    implements AdvancementSubProvider {
        public void generate(@NotNull HolderLookup.Provider provider, @NotNull Consumer<AdvancementHolder> consumer) {
            HolderLookup.RegistryLookup structureLookup = provider.lookupOrThrow(Registries.STRUCTURE);
            HolderLookup.RegistryLookup bannerLookup = provider.lookupOrThrow(Registries.BANNER_PATTERN);
            AdvancementHolder root = new AdvancementBuilder("root", (ItemLike)Items.COMPASS).background("textures/block/mossy_cobblestone.png").hideToast().hideInChat().orCriterions().onEnterStructures((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.ALL_STRUCTURE_REGISTRARS).save(consumer);
            new AdvancementBuilder("hidden_under_the_roots", (ItemLike)Items.JACK_O_LANTERN).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.MONSTER_MAZE).save(consumer);
            new AdvancementBuilder("thats_a_dungeon", (ItemLike)Items.SKELETON_SKULL).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.LARGE_DUNGEON).save(consumer);
            new AdvancementBuilder("traps_and_curses", (ItemLike)Items.TNT).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.DESERT_TEMPLE).save(consumer);
            new AdvancementBuilder("ancient_civilizations", (ItemLike)Items.BAMBOO).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.JUNGLE_MONUMENT).save(consumer);
            new AdvancementBuilder("wars_and_kingdoms", (ItemLike)Items.STONE_BRICKS).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.CASTLE).save(consumer);
            new AdvancementBuilder("rarest_structure", (ItemLike)Items.RED_MUSHROOM).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.MUSHROOM_HOUSE).save(consumer);
            new AdvancementBuilder("chilled_halls", (ItemLike)Items.BONE).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.ICE_PIT).save(consumer);
            new AdvancementBuilder("ahoy", (ItemLike)Items.WITHER_SKELETON_SKULL).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.PIRATE_SHIP).save(consumer);
            new AdvancementBuilder("in_the_air", (ItemLike)Items.LANTERN).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.FLYING_DUTCHMAN).save(consumer);
            new AdvancementBuilder("sunken_deeps", (ItemLike)Items.NAUTILUS_SHELL).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.ELDERS_TEMPLE).save(consumer);
            new AdvancementBuilder("spooky_scary_citadel", new BannerBuilder(Items.RED_BANNER).addPattern((HolderGetter<BannerPattern>)bannerLookup, (ResourceKey<BannerPattern>)BannerPatterns.BRICKS, DyeColor.BLACK).addPattern((HolderGetter<BannerPattern>)bannerLookup, (ResourceKey<BannerPattern>)BannerPatterns.GRADIENT_UP, DyeColor.RED).addPattern((HolderGetter<BannerPattern>)bannerLookup, (ResourceKey<BannerPattern>)BannerPatterns.SKULL, DyeColor.BLACK).addPattern((HolderGetter<BannerPattern>)bannerLookup, (ResourceKey<BannerPattern>)BannerPatterns.BORDER, DyeColor.BLACK).build()).parent(root).onEnterStructure((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.BLACK_CITADEL).save(consumer);
            AdvancementHolder sevenWorldWonders = new AdvancementBuilder("seven_world_wonders", (ItemLike)Items.SPYGLASS).parent(root).type(AdvancementType.GOAL).onEnterStructures((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.CASTLE, DEStructures.DEEP_CRYPT, DEStructures.DESERT_TEMPLE, DEStructures.ICE_PIT, DEStructures.JUNGLE_MONUMENT, DEStructures.MONSTER_MAZE, DEStructures.ELDERS_TEMPLE).save(consumer);
            new AdvancementBuilder("ambitious_explorer", (ItemLike)Items.FILLED_MAP).parent(sevenWorldWonders).type(AdvancementType.CHALLENGE).onEnterStructures((HolderLookup.RegistryLookup<Structure>)structureLookup, DEStructures.ALL_STRUCTURE_REGISTRARS).save(consumer);
        }
    }

    private static class BannerBuilder {
        private final Item _bannerItem;
        private final BannerPatternLayers.Builder _layers = new BannerPatternLayers.Builder();

        public BannerBuilder(Item item) {
            this._bannerItem = item;
        }

        public BannerBuilder addPattern(HolderGetter<BannerPattern> lookup, ResourceKey<BannerPattern> pattern, DyeColor color) {
            this._layers.add((Holder)lookup.get(pattern).orElseThrow(), color);
            return this;
        }

        public ItemStack build() {
            ItemStack stack = new ItemStack((ItemLike)this._bannerItem);
            stack.set(DataComponents.BANNER_PATTERNS, (Object)this._layers.build());
            return stack;
        }
    }

    private static class AdvancementBuilder {
        private final String _id;
        private final ItemStack _displayItem;
        private AdvancementHolder _parent = null;
        private ResourceLocation _background = null;
        private AdvancementType _type = AdvancementType.TASK;
        private boolean _showToast = true;
        private boolean _announceToChat = true;
        private boolean _hidden = false;
        private AdvancementRequirements.Strategy _criterionStrategy = AdvancementRequirements.Strategy.AND;
        private final List<Pair<String, Criterion<?>>> _criterions = new ArrayList();

        private AdvancementBuilder(String id, ItemStack displayItem) {
            this._id = id;
            this._displayItem = displayItem;
        }

        private AdvancementBuilder(String id, ItemLike displayItem) {
            this(id, displayItem.asItem().getDefaultInstance());
        }

        private AdvancementBuilder parent(AdvancementHolder parent) {
            this._parent = parent;
            return this;
        }

        public AdvancementBuilder background(String background) {
            return this.background(ResourceLocation.withDefaultNamespace((String)background));
        }

        public AdvancementBuilder background(ResourceLocation background) {
            this._background = background;
            return this;
        }

        public AdvancementBuilder type(AdvancementType type) {
            this._type = type;
            return this;
        }

        public AdvancementBuilder hideCompletely() {
            return this.hideToast().hideInChat().hide();
        }

        public AdvancementBuilder hideToast() {
            return this.showToast(false);
        }

        public AdvancementBuilder showToast(boolean show) {
            this._showToast = show;
            return this;
        }

        public AdvancementBuilder hideInChat() {
            return this.announceToChat(false);
        }

        public AdvancementBuilder announceToChat(boolean announce) {
            this._announceToChat = announce;
            return this;
        }

        public AdvancementBuilder hide() {
            return this.hidden(true);
        }

        public AdvancementBuilder hidden(boolean hidden) {
            this._hidden = hidden;
            return this;
        }

        public AdvancementBuilder orCriterions() {
            return this.criterionStrategy(AdvancementRequirements.Strategy.OR);
        }

        public AdvancementBuilder criterionStrategy(AdvancementRequirements.Strategy strategy) {
            this._criterionStrategy = strategy;
            return this;
        }

        public AdvancementBuilder onEnterStructures(HolderLookup.RegistryLookup<Structure> lookup, StructureRegistrar<?> ... structureRegistrars) {
            for (StructureRegistrar<?> structure : structureRegistrars) {
                this.onEnterStructure(lookup, structure);
            }
            return this;
        }

        public AdvancementBuilder onEnterStructure(HolderLookup.RegistryLookup<Structure> lookup, @NotNull StructureRegistrar<?> structureRegistrar) {
            return this.onEnterStructure((Holder<Structure>)((Holder)Objects.requireNonNull(structureRegistrar.getStructure()).getHolder(lookup).orElseThrow()));
        }

        public AdvancementBuilder onEnterStructure(@NotNull Holder<Structure> structureHolder) {
            this._criterions.add(new Pair((Object)("entered_" + Objects.requireNonNull(structureHolder.getKey()).location().getPath()), (Object)PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure(structureHolder))));
            return this;
        }

        public AdvancementHolder save(@NotNull Consumer<AdvancementHolder> consumer) {
            Advancement.Builder builder = new Advancement.Builder().display(this._displayItem, AdvancementBuilder.component(this._id), AdvancementBuilder.component(this._id + ".desc"), this._background, this._type, this._showToast, this._announceToChat, this._hidden).requirements(this._criterionStrategy);
            for (Pair<String, Criterion<?>> pair : this._criterions) {
                builder.addCriterion((String)pair.getFirst(), (Criterion)pair.getSecond());
            }
            if (this._parent != null) {
                builder.parent(this._parent);
            }
            return builder.save(consumer, DungeonsEnhanced.locate(this._id));
        }

        private static Component component(String key) {
            return Component.translatable((String)("advancements.dungeons_enhanced." + key));
        }
    }
}

