/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.data.provider;

import com.google.common.hash.Hashing;
import com.mojang.datafixers.DataFixerUpper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.jetbrains.annotations.NotNull;

public final class StructureNbtUpdater
implements DataProvider {
    private final String basePath;
    private final String modid;
    private final PackOutput output;
    private final MultiPackResourceManager resources;

    public StructureNbtUpdater(PackOutput output) {
        this.basePath = "structure";
        this.modid = "dungeons_enhanced";
        this.output = output;
        this.resources = new MultiPackResourceManager(PackType.SERVER_DATA, List.of(ResourcePackLoader.createPackForMod((IModFileInfo)ModList.get().getModFileById(this.modid)).openPrimary(new PackLocationInfo("mod/" + this.modid, (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty()))));
    }

    @NotNull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        try {
            for (Map.Entry entry : this.resources.listResources(this.basePath, $ -> true).entrySet()) {
                if (!((ResourceLocation)entry.getKey()).getNamespace().equals(this.modid)) continue;
                this.process((ResourceLocation)entry.getKey(), (Resource)entry.getValue(), cache);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException x) {
            return CompletableFuture.failedFuture(x);
        }
    }

    private void process(ResourceLocation loc, Resource resource, CachedOutput cache) throws IOException {
        CompoundTag inputNBT = NbtIo.readCompressed((InputStream)resource.open(), (NbtAccounter)NbtAccounter.unlimitedHeap());
        CompoundTag converted = StructureNbtUpdater.updateNBT(inputNBT);
        if (!converted.equals((Object)inputNBT)) {
            LOGGER.info("Found outdated NBT file: {}", (Object)loc);
            Class fixerClass = DataFixers.getDataFixer().getClass();
            if (!fixerClass.equals(DataFixerUpper.class)) {
                throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
            }
            this.writeNBTTo(loc, converted, cache);
        }
    }

    private void writeNBTTo(ResourceLocation loc, CompoundTag data, CachedOutput cache) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        NbtIo.writeCompressed((CompoundTag)data, (OutputStream)bytearrayoutputstream);
        byte[] bytes = bytearrayoutputstream.toByteArray();
        Path outputPath = this.output.getOutputFolder().resolve("data/" + loc.getNamespace() + "/" + loc.getPath());
        cache.writeIfNeeded(outputPath, bytes, Hashing.sha1().hashBytes(bytes));
    }

    private static CompoundTag updateNBT(CompoundTag nbt) {
        CompoundTag updatedNBT = DataFixTypes.STRUCTURE.updateToCurrentVersion(DataFixers.getDataFixer(), nbt, nbt.getInt("DataVersion"));
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK, updatedNBT);
        return template.save(new CompoundTag());
    }

    @Nonnull
    public String getName() {
        return "Update structure files in " + this.basePath;
    }
}

