/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.registry;

import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.data.DETags;
import com.barion.dungeons_enhanced.registry.DEProcessors;
import com.barion.dungeons_enhanced.registry.DETemplatePools;
import com.barion.dungeons_enhanced.world.structure.DEBlackCitadel;
import com.barion.dungeons_enhanced.world.structure.DECastle;
import com.barion.dungeons_enhanced.world.structure.DEDeepCrypt;
import com.barion.dungeons_enhanced.world.structure.DEDesertTemple;
import com.barion.dungeons_enhanced.world.structure.DEDesertTomb;
import com.barion.dungeons_enhanced.world.structure.DEDruidCircle;
import com.barion.dungeons_enhanced.world.structure.DEEldersTemple;
import com.barion.dungeons_enhanced.world.structure.DEIcePit;
import com.barion.dungeons_enhanced.world.structure.DELargeDungeon;
import com.barion.dungeons_enhanced.world.structure.DEMonsterMaze;
import com.barion.dungeons_enhanced.world.structure.DEPillagerCamp;
import com.barion.dungeons_enhanced.world.structure.DEPirateShip;
import com.barion.dungeons_enhanced.world.structure.builder.DEModularRegistrarBuilder;
import com.barion.dungeons_enhanced.world.structure.builder.DEPlacement;
import com.barion.dungeons_enhanced.world.structure.builder.DEPlacementFilter;
import com.barion.dungeons_enhanced.world.structure.builder.DEStructureTemplate;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEGroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEModularStructure;
import com.barion.dungeons_enhanced.world.structure.processor.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.registry.RegistrarHolder;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;

@RegistrarHolder
public final class DEStructures {
    public static final StructureRegistrar<ExtendedJigsawStructure> CASTLE = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("castle")).placement(() -> DEStructures.gridPlacement(69, 78).build(CASTLE)).addPiece(() -> DECastle.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DECastle.Capability.INSTANCE, DETemplatePools.CASTLE, 1, (HeightProvider)ConstantHeight.ZERO).onSurface().build()).terrainAdjustment(TerrainAdjustment.BEARD_BOX).biomes(DETags.Biomes.HAS_CASTLE).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DEEP_CRYPT = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("deep_crypt")).placement(() -> DEStructures.gridPlacement(39, 67).build(DEEP_CRYPT)).addPiece(() -> DEDeepCrypt.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDeepCrypt.Capability.INSTANCE, DETemplatePools.DEEP_CRYPT, 4, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)16), (VerticalAnchor)VerticalAnchor.aboveBottom((int)48))).build()).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).biomes(DETags.Biomes.HAS_DEEP_CRYPT).popStructure().build();
    public static final StructureRegistrar<DEDesertTemple> DESERT_TEMPLE = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("desert_temple"), () -> () -> DEDesertTemple.CODEC).placement(() -> DEStructures.gridPlacement(39, 86).build(DESERT_TEMPLE)).addPiece(() -> DEDesertTemple.Piece::new).pushStructure(DEDesertTemple::new).biomes(DETags.Biomes.HAS_DESERT_TEMPLE).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DESERT_TOMB = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("desert_tomb")).placement(() -> DEStructures.gridPlacement(29, 65).allowedNearSpawn(true).build(DESERT_TOMB)).addPiece(() -> DEDesertTomb.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDesertTomb.Capability.INSTANCE, DETemplatePools.DESERT_TOMB, 5, (HeightProvider)ConstantHeight.ZERO).onSurface().build()).biomes(DETags.Biomes.HAS_DESERT_TOMB).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DRUID_CIRCLE = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("druid_circle")).placement(() -> DEStructures.gridPlacement(41, 68).allowedNearSpawn(true).build(DRUID_CIRCLE)).addPiece(() -> DEDruidCircle.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDruidCircle.Capability.INSTANCE, DETemplatePools.DRUID_CIRCLE, 1, (HeightProvider)ConstantHeight.ZERO).onSurface().build()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(DETags.Biomes.HAS_DRUID_CIRCLE).popStructure().build();
    public static final StructureRegistrar<DEModularStructure> DUNGEON_VARIANT = DEModularRegistrarBuilder.create(() -> DUNGEON_VARIANT, "dungeon_variant").addStructure(pieceFactory -> pieceFactory.add("dungeon_variant/zombie").add("dungeon_variant/skeleton").add("dungeon_variant/spider").add("dungeon_variant/special").settings(settings -> settings.addProcessor((StructureProcessor)DEProcessors.MOSSY_COBBLESTONE_40).addProcessor((StructureProcessor)DEProcessors.MOSSY_COBBLESTONE_STAIRS_40).addProcessor((StructureProcessor)DEProcessors.MOSSY_COBBLESTONE_SLAB_40).addProcessor((StructureProcessor)DEProcessors.MOSSY_STONE_BRICKS_30).addProcessor((StructureProcessor)DEProcessors.CRACK_STONE_BRICKS_20)), structure -> structure.placement(DEPlacement.UNDERGROUND), config -> config.biomes(DETags.Biomes.HAS_DUNGEON_VARIANT).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES)).placement(19, 0.59f).allowNearSpawn().build();
    public static final StructureRegistrar<DEEldersTemple> ELDERS_TEMPLE = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("elders_temple"), () -> () -> DEEldersTemple.CODEC).placement(() -> DEStructures.gridPlacement(24).build(ELDERS_TEMPLE)).addPiece(() -> DEEldersTemple.Piece::new).pushStructure(DEEldersTemple::new).biomes(DETags.Biomes.HAS_ELDERS_TEMPLE).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.GUARDIAN, 1, 2, 4))).popStructure().build();
    public static final StructureRegistrar<DEModularStructure> FISHING_SHIP = DEModularRegistrarBuilder.create(() -> FISHING_SHIP, "fishing_ship").addStructure(DEStructureTemplate.of("fishing_ship", -3), structure -> structure.placement(DEPlacement.WORLD_SURFACE), config -> config.biomes(DETags.Biomes.HAS_FISHING_SHIP)).placement(48, 0.68f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> FLYING_DUTCHMAN = DEModularRegistrarBuilder.create(() -> FLYING_DUTCHMAN, "flying_dutchman").addStructure(DungeonsEnhanced.locate("flying_dutchman"), structure -> structure.placement(DEPlacement.ABOVE_GROUND), config -> config.biomes(DETags.Biomes.HAS_FLYING_DUTCHMAN)).placement(134, 0.63f).build();
    public static final StructureRegistrar<DEModularStructure> HAY_STORAGE = DEModularRegistrarBuilder.create(() -> HAY_STORAGE, "hay_storage").addStructure(pieceFactory -> pieceFactory.add("hay_storage/small").add("hay_storage/big"), structure -> structure.placement(DEPlacement.OCEAN_FLOOR), config -> config.biomes(DETags.Biomes.HAS_HAY_STORAGE).terrainAdjustment(TerrainAdjustment.BEARD_THIN)).placement(23, 0.77f).allowNearSpawn().build();
    public static final StructureRegistrar<DEIcePit> ICE_PIT = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("ice_pit"), () -> () -> DEIcePit.CODEC).addPiece(() -> DEGroundStructure.Piece::new).placement(() -> DEStructures.gridPlacement(34, 77).build(ICE_PIT)).pushStructure(DEIcePit::new).biomes(DETags.Biomes.HAS_ICE_PIT).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> JUNGLE_MONUMENT = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("jungle_monument"), () -> () -> DEGroundStructure.CODEC_JUNGLE_MONUMENT).placement(() -> DEStructures.gridPlacement(46, 74).build(JUNGLE_MONUMENT)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::JungleMonument).biomes(DETags.Biomes.HAS_JUNGLE_MONUMENT).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> LARGE_DUNGEON = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("large_dungeon")).placement(() -> DEStructures.gridPlacement(59, 56).allowedNearSpawn(true).build(LARGE_DUNGEON)).addPiece(() -> DELargeDungeon.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DELargeDungeon.Capability.INSTANCE, DETemplatePools.LARGE_DUNGEON, 5, (HeightProvider)DEStructures.height(-16)).onSurface().build()).biomes(DETags.Biomes.HAS_LARGE_DUNGEON).popStructure().build();
    public static final StructureRegistrar<DEModularStructure> MINERS_HOUSE = DEModularRegistrarBuilder.create(() -> MINERS_HOUSE, "miners_house").addStructure(DungeonsEnhanced.locate("miners_house"), structure -> structure.placement(DEPlacement.WORLD_SURFACE_FLAT), config -> config.biomes(DETags.Biomes.HAS_MINERS_HOUSE).terrainAdjustment(TerrainAdjustment.BEARD_THIN)).placement(24, 0.8f).allowNearSpawn().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> MONSTER_MAZE = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("monster_maze")).placement(() -> DEStructures.gridPlacement(32, 52).build(MONSTER_MAZE)).addPiece(() -> DEMonsterMaze.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEMonsterMaze.Capability.INSTANCE, DETemplatePools.MONSTER_MAZE, 12, (HeightProvider)DEStructures.height(-17)).onSurface().build()).biomes(DETags.Biomes.HAS_MONSTER_MAZE).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> MUSHROOM_HOUSE = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("mushroom_house"), () -> () -> DEGroundStructure.CODEC_MUSHROOM_HOUSE).placement(() -> DEStructures.gridPlacement(19, 83).allowedNearSpawn(true).build(MUSHROOM_HOUSE)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::MushroomHouse).biomes(DETags.Biomes.HAS_MUSHROOM_HOUSE).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> PILLAGER_CAMP = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("pillager_camp")).placement(() -> DEStructures.gridPlacement(56, 39).build(PILLAGER_CAMP)).addPiece(() -> DEPillagerCamp.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEPillagerCamp.Capability.INSTANCE, DETemplatePools.PILLAGER_CAMP, 4, (HeightProvider)ConstantHeight.ZERO).onSurface().build()).biomes(DETags.Biomes.HAS_PILLAGER_CAMP).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.PILLAGER, 4, 2, 3), DEStructures.spawn(EntityType.VINDICATOR, 2, 1, 2))).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<DEPirateShip> PIRATE_SHIP = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("pirate_ship"), () -> () -> DEPirateShip.CODEC).placement(() -> DEStructures.gridPlacement(67, 49).build(PIRATE_SHIP)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEPirateShip::new).biomes(DETags.Biomes.HAS_PIRATE_SHIP).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.PILLAGER, 4, 3, 4), DEStructures.spawn(EntityType.VINDICATOR, 3, 1, 2))).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popStructure().build();
    public static final StructureRegistrar<DEModularStructure> RUINED_BUILDING = DEModularRegistrarBuilder.create(() -> RUINED_BUILDING, "ruined_building").addStructure(pieceFactory -> pieceFactory.add(3, "ruined_building/house").add(3, "ruined_building/barn").add(2, "ruined_building/house_big"), structure -> structure.placement(DEPlacement.OCEAN_FLOOR), config -> config.biomes(DETags.Biomes.HAS_RUINED_BUILDING).terrainAdjustment(TerrainAdjustment.BEARD_THIN)).placement(27, 0.54f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> STABLES = DEModularRegistrarBuilder.create(() -> STABLES, "stables").addStructure(DEStructureTemplate.of("stables", -5), structure -> structure.placement(DEPlacement.OCEAN_FLOOR), config -> config.biomes(DETags.Biomes.HAS_STABLES)).placement(53, 0.52f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> SUNKEN_SHRINE = DEModularRegistrarBuilder.create(() -> SUNKEN_SHRINE, "sunken_shrine").addStructure(pieces -> pieces.settings(settings -> settings.setLiquidSettings(LiquidSettings.APPLY_WATERLOGGING).popProcessor((StructureProcessor)RemoveGelStructureProcessor.INSTANCE).addProcessor((StructureProcessor)DEUnderwaterProcessor.INSTANCE)).add(2, "sunken_shrine/small").add(1, "sunken_shrine/big", -1), structure -> structure.placement(DEPlacement.OCEAN_FLOOR).filter(DEPlacementFilter.MinWaterHeight(12)), config -> config.biomes(DETags.Biomes.HAS_SUNKEN_SHRINE)).placement(32, 0.55f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> TALL_WITCH_HUT = DEModularRegistrarBuilder.create(() -> TALL_WITCH_HUT, "tall_witch_hut").addStructure(DEStructureTemplate.of("tall_witch_hut", -3), structure -> structure.placement(DEPlacement.WORLD_SURFACE_FLAT).filter(DEPlacementFilter.MaxWaterDepth(4)), config -> config.biomes(DETags.Biomes.HAS_TALL_WITCH_HUT)).placement(21, 0.61f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> TREE_HOUSE = DEModularRegistrarBuilder.create(() -> TREE_HOUSE, "tree_house").addStructure(DungeonsEnhanced.locate("tree_house"), structure -> structure.placement(DEPlacement.WORLD_SURFACE_FLAT), config -> config.terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(DETags.Biomes.HAS_TREE_HOUSE)).placement(29, 0.4f).allowNearSpawn().build();
    public static final StructureRegistrar<DEModularStructure> TOWER_OF_THE_UNDEAD = DEModularRegistrarBuilder.create(() -> TOWER_OF_THE_UNDEAD, "tower_of_the_undead").addStructure(pieces -> pieces.add(3, "tower_of_the_undead/small").add(2, "tower_of_the_undead/big"), structure -> structure.placement(DEPlacement.WORLD_SURFACE_FLAT).filter(DEPlacementFilter.NO_WATER), config -> config.biomes(DETags.Biomes.HAS_TOWER_OF_THE_UNDEAD).terrainAdjustment(TerrainAdjustment.BEARD_THIN)).placement(49, 0.65f).allowNearSpawn().build();
    public static final StructureRegistrar<DEGroundStructure> WATCH_TOWER = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("watch_tower"), () -> () -> DEGroundStructure.CODEC_WATCH_TOWER).placement(() -> DEStructures.gridPlacement(27, 45).allowedNearSpawn(true).build(WATCH_TOWER)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::WatchTower).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(DETags.Biomes.HAS_WATCH_TOWER).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> WITCH_TOWER = StructureRegistrar.builder((ResourceLocation)DungeonsEnhanced.locate("witch_tower"), () -> () -> DEGroundStructure.CODEC_WITCH_TOWER).placement(() -> DEStructures.gridPlacement(79, 54).allowedNearSpawn(true).build(WITCH_TOWER)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::WitchTower).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(DETags.Biomes.HAS_WITCH_TOWER).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> BLACK_CITADEL = StructureRegistrar.jigsawBuilder((ResourceLocation)DungeonsEnhanced.locate("black_citadel")).placement(() -> DEStructures.gridPlacement(67, 75).build(BLACK_CITADEL)).addPiece(() -> DEBlackCitadel.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEBlackCitadel.Capability.INSTANCE, DETemplatePools.BLACK_CITADEL, 6, (HeightProvider)DEStructures.height(28)).maxDistanceFromCenter(116).build()).biomes(DETags.Biomes.HAS_BLACK_CITADEL).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, DEStructures.spawns(DEStructures.spawn(EntityType.WITHER_SKELETON, 4, 2, 5), DEStructures.spawn(EntityType.SKELETON, 1, 1, 3))).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdjustment(TerrainAdjustment.BEARD_BOX).popStructure().build();
    public static final StructureRegistrar<?>[] ALL_STRUCTURE_REGISTRARS = new StructureRegistrar[]{CASTLE, DEEP_CRYPT, DESERT_TEMPLE, DESERT_TOMB, DRUID_CIRCLE, DUNGEON_VARIANT, ELDERS_TEMPLE, FISHING_SHIP, FLYING_DUTCHMAN, HAY_STORAGE, ICE_PIT, JUNGLE_MONUMENT, LARGE_DUNGEON, MINERS_HOUSE, MONSTER_MAZE, MUSHROOM_HOUSE, PILLAGER_CAMP, PIRATE_SHIP, RUINED_BUILDING, STABLES, SUNKEN_SHRINE, TALL_WITCH_HUT, TOWER_OF_THE_UNDEAD, TREE_HOUSE, WATCH_TOWER, WITCH_TOWER, BLACK_CITADEL};

    private DEStructures() {
    }

    private static ConstantHeight height(int y) {
        return ConstantHeight.of((VerticalAnchor)new VerticalAnchor.Absolute(y));
    }

    private static Supplier<List<MobSpawnSettings.SpawnerData>> spawns(MobSpawnSettings.SpawnerData ... spawns) {
        return () -> Arrays.stream(spawns).toList();
    }

    private static MobSpawnSettings.SpawnerData spawn(EntityType<?> entity, int weight, int min, int max) {
        return new MobSpawnSettings.SpawnerData(entity, weight, min, max);
    }

    private static GridStructurePlacement.Builder gridPlacement(int spacing, int probability) {
        return DEStructures.gridPlacement(spacing).probability((float)probability / 100.0f);
    }

    private static GridStructurePlacement.Builder gridPlacement(int spacing) {
        return GridStructurePlacement.builder().spacing(spacing).offset((int)((double)spacing * 0.8));
    }

    private static ExtendedJigsawStructure.Builder extendedJigsawStructure(BootstrapContext<?> context, Structure.StructureSettings settings, JigsawCapability capability, ResourceKey<StructureTemplatePool> poolKey, int maxDepth, HeightProvider heightProvider) {
        return ExtendedJigsawStructure.builder((Structure.StructureSettings)settings, (Holder)context.lookup(Registries.TEMPLATE_POOL).getOrThrow(poolKey)).maxDepth(maxDepth).startHeight(heightProvider).capability(capability);
    }
}

