/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEUnderwaterStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.processor.DESwapDeadCoralsProcessor;
import com.barion.dungeons_enhanced.world.structure.processor.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class DEEldersTemple
extends DEUnderwaterStructure {
    public static final MapCodec<DEEldersTemple> CODEC = DEEldersTemple.simpleCodec(DEEldersTemple::new);
    private static final ResourceLocation NE = DungeonsEnhanced.locate("elders_temple/ne");
    private static final ResourceLocation NW = DungeonsEnhanced.locate("elders_temple/nw");
    private static final ResourceLocation SE = DungeonsEnhanced.locate("elders_temple/se");
    private static final ResourceLocation SW = DungeonsEnhanced.locate("elders_temple/sw");

    public DEEldersTemple(Structure.StructureSettings settings) {
        super(settings, DEUtil.pieceBuilder().add("elders_temple/se").build(), () -> DEStructures.ELDERS_TEMPLE.getType());
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> findGenerationPoint(@Nonnull Structure.GenerationContext context) {
        BlockPos pos = DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        if (!DETerrainAnalyzer.isUnderwater(pos, context.chunkGenerator(), 32, context.heightAccessor(), context.randomState())) {
            return Optional.empty();
        }
        if (!DETerrainAnalyzer.areNearbyBiomesValid(context.biomeSource(), pos, context.chunkGenerator(), 30, context.validBiome(), context.randomState())) {
            return Optional.empty();
        }
        return DEEldersTemple.at(pos, builder -> DEEldersTemple.generatePieces(builder, pos, this._templates.getRandom((RandomSource)context.random()), Rotation.getRandom((RandomSource)context.random()), context, DEEldersTemple::assembleTemple));
    }

    public static void assembleTemple(DEPieceAssembler.Context context) {
        Rotation rotation = Rotation.NONE;
        context.piecesBuilder().addPiece((StructurePiece)new Piece(context.structureManager(), SE, context.pos().offset(0, 0, 0), rotation));
        context.piecesBuilder().addPiece((StructurePiece)new Piece(context.structureManager(), SW, context.pos().offset(-30, 0, 0), rotation));
        context.piecesBuilder().addPiece((StructurePiece)new Piece(context.structureManager(), NE, context.pos().offset(0, 0, -29), rotation));
        context.piecesBuilder().addPiece((StructurePiece)new Piece(context.structureManager(), NW, context.pos().offset(-30, 0, -29), rotation));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.ELDERS_TEMPLE.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.ELDERS_TEMPLE.getPieceType(), serializationContext, nbt);
        }

        @Override
        protected void addProcessors(StructurePlaceSettings settings) {
            settings.clearProcessors();
            settings.addProcessor((StructureProcessor)DEUnderwaterProcessor.INSTANCE).addProcessor((StructureProcessor)DESwapDeadCoralsProcessor.INSTANCE);
        }
    }
}

