/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEGroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public final class DEIcePit
extends DEGroundStructure {
    public static final MapCodec<DEIcePit> CODEC = DEIcePit.simpleCodec(DEIcePit::new);
    private static final ResourceLocation ENTRANCE = DungeonsEnhanced.locate("ice_pit/top");

    public DEIcePit(Structure.StructureSettings settings) {
        super(settings, DEUtil.pieceBuilder().yOffset(-25).add("ice_pit/var1").add("ice_pit/var2").add("ice_pit/var3").build(), () -> DEStructures.ICE_PIT.getType());
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> findGenerationPoint(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template template = this._templates.getRandom((RandomSource)context.random());
        BlockPos pos = DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()).above(template.yOffset);
        return DEIcePit.at(pos, builder -> DEIcePit.generatePieces(builder, pos, template, Rotation.getRandom((RandomSource)context.random()), context, DEIcePit::assembleIcePit));
    }

    private static void assembleIcePit(DEPieceAssembler.Context context) {
        BlockPos pos = context.pos();
        context.piecesBuilder().addPiece((StructurePiece)new DEGroundStructure.Piece(context.structureManager(), ENTRANCE, pos, context.rotation()));
        int yOffset = -6;
        if (context.piece().getPath().contains("var3")) {
            yOffset = -11;
        }
        context.piecesBuilder().addPiece((StructurePiece)new DEGroundStructure.Piece(context.structureManager(), context.piece(), pos.offset(-17, yOffset, -17), context.rotation()));
    }
}

