/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.registry.DEJigsawTypes;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.registry.DETemplatePools;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapabilityType;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public final class DELargeDungeon {
    public static void pool(BootstrapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_enhanced", "large_dungeon/", context);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"root"}).maintainWater(false)).register(DETemplatePools.LARGE_DUNGEON);
        JigsawPoolBuilder basePool = registry.poolBuilder().maintainWater(false);
        JigsawPoolBuilder Cross = basePool.clone().names(new String[]{"cross"});
        JigsawPoolBuilder Rooms = basePool.clone().names(new String[]{"room_small1", "room_small2", "room1", "room2", "room_big", "parkour", "storage"});
        JigsawPoolBuilder Tunnels = basePool.clone().names(new String[]{"tunnel"});
        JigsawPoolBuilder Stairs = basePool.clone().names(new String[]{"stairs"});
        registry.register("cross", (List)Cross.build());
        registry.register("main", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{Tunnels.weight(4), Stairs.weight(2), Cross.weight(2), Rooms.weight(1)}));
    }

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(serializationContext, nbt);
        }

        @NotNull
        public StructurePieceType getType() {
            return Objects.requireNonNull((StructurePieceType)DEStructures.LARGE_DUNGEON.getPieceType().get());
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor levelAccessor, RandomSource random, BoundingBox box) {
        }
    }

    public static class Capability
    implements JigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final MapCodec<Capability> CODEC = MapCodec.unit((Object)INSTANCE);

        public JigsawCapabilityType<?> getType() {
            return (JigsawCapabilityType)DEJigsawTypes.LARGE_DUNGEON.get();
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

