/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;

public final class DEPirateShip
extends Structure {
    public static final MapCodec<DEPirateShip> CODEC = DEPirateShip.simpleCodec(DEPirateShip::new);
    private static final ResourceLocation FRONT = DungeonsEnhanced.locate("pirate_ship/front");
    private static final ResourceLocation BACK = DungeonsEnhanced.locate("pirate_ship/back");

    public DEPirateShip(Structure.StructureSettings settings) {
        super(settings);
    }

    @Nonnull
    public Optional<Structure.GenerationStub> findGenerationPoint(@Nonnull Structure.GenerationContext context) {
        BlockPos pos = this.getGenPos(context).below(3);
        return Optional.of(new Structure.GenerationStub(pos, builder -> {
            builder.addPiece((StructurePiece)new DEBaseStructure.Piece((Registrar.Static<StructurePieceType>)DEStructures.PIRATE_SHIP.getPieceType(), context.structureTemplateManager(), FRONT, pos, Rotation.NONE));
            builder.addPiece((StructurePiece)new DEBaseStructure.Piece((Registrar.Static<StructurePieceType>)DEStructures.PIRATE_SHIP.getPieceType(), context.structureTemplateManager(), BACK, pos.offset(25, 0, 0), Rotation.NONE));
        }));
    }

    @NotNull
    public StructureType<?> type() {
        return DEStructures.PIRATE_SHIP.getType();
    }

    private BlockPos getGenPos(Structure.GenerationContext context) {
        return DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
    }
}

