/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.world.structure.builder.DERandomPieceFactory;
import com.barion.dungeons_enhanced.world.structure.builder.DESinglePieceFactory;
import com.barion.dungeons_enhanced.world.structure.builder.DEStructureTemplate;
import com.barion.dungeons_enhanced.world.structure.builder.IDEPieceFactory;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEModularStructure;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public final class DEModularRegistrarBuilder {
    private final Supplier<StructureRegistrar<DEModularStructure>> _registrar;
    private final StructureRegistrar.Builder<DEModularStructure> _builder;
    private final GridStructurePlacement.Builder _placement = GridStructurePlacement.builder();
    private MapCodec<DEModularStructure> _codec;

    public static DEModularRegistrarBuilder create(Supplier<StructureRegistrar<DEModularStructure>> registrar, String id) {
        return DEModularRegistrarBuilder.create(registrar, id, null);
    }

    public static DEModularRegistrarBuilder create(Supplier<StructureRegistrar<DEModularStructure>> registrar, String id, MapCodec<DEModularStructure> codec) {
        return DEModularRegistrarBuilder.create(registrar, DungeonsEnhanced.locate(id), codec);
    }

    public static DEModularRegistrarBuilder create(Supplier<StructureRegistrar<DEModularStructure>> registrar, ResourceLocation id, MapCodec<DEModularStructure> codec) {
        return new DEModularRegistrarBuilder(registrar, id, codec);
    }

    public DEModularRegistrarBuilder(Supplier<StructureRegistrar<DEModularStructure>> registrar, ResourceLocation resourceLocation, @Nullable MapCodec<DEModularStructure> codec) {
        this._registrar = registrar;
        this._codec = codec;
        this._builder = StructureRegistrar.builder((ResourceLocation)resourceLocation, () -> () -> this._codec);
    }

    public DEModularRegistrarBuilder placement(int spacing) {
        return this.placement(spacing, 1.0f);
    }

    public DEModularRegistrarBuilder placement(int spacing, float probability) {
        return this.placement(spacing, (int)((double)spacing * 0.8), probability);
    }

    public DEModularRegistrarBuilder placement(int spacing, int offset, float probability) {
        if (probability > 1.0f) {
            throw new IllegalArgumentException("Probability needs to be between 0 and 1");
        }
        this._placement.spacing(spacing).offset(offset).probability(probability);
        return this;
    }

    public DEModularRegistrarBuilder placement(Consumer<GridStructurePlacement.Builder> placementConsumer) {
        placementConsumer.accept(this._placement);
        return this;
    }

    public DEModularRegistrarBuilder allowNearSpawn() {
        return this.allowedNearSpawn(true);
    }

    public DEModularRegistrarBuilder allowedNearSpawn(boolean allow) {
        this._placement.allowedNearSpawn(allow);
        return this;
    }

    public DEModularRegistrarBuilder addStructure(Function<DERandomPieceFactory.Builder, DERandomPieceFactory.Builder> pieceFactoryConsumer, Function<DEModularStructure.Builder, DEModularStructure.Builder> builderConsumer, Function<StructureRegistrar.StructureBuilder<DEModularStructure>, StructureRegistrar.StructureBuilder<DEModularStructure>> configuratorConsumer) {
        DERandomPieceFactory.Builder pieceFactoryBuilder = pieceFactoryConsumer.apply(new DERandomPieceFactory.Builder());
        DERandomPieceFactory pieceFactory = pieceFactoryBuilder.build(() -> (StructurePieceType)this._registrar.get().getPieceType().get());
        DEModularStructure.Builder structureBuilder = builderConsumer.apply(new DEModularStructure.Builder(pieceFactory, () -> this._registrar.get().getType()));
        return this.addStructure(pieceFactory, structureBuilder, configuratorConsumer);
    }

    public DEModularRegistrarBuilder addStructure(ResourceLocation template, Function<DEModularStructure.Builder, DEModularStructure.Builder> builderConsumer, Function<StructureRegistrar.StructureBuilder<DEModularStructure>, StructureRegistrar.StructureBuilder<DEModularStructure>> configuratorConsumer) {
        return this.addStructure(new DEStructureTemplate(template, 0), builderConsumer, configuratorConsumer);
    }

    public DEModularRegistrarBuilder addStructure(DEStructureTemplate template, Function<DEModularStructure.Builder, DEModularStructure.Builder> builderConsumer, Function<StructureRegistrar.StructureBuilder<DEModularStructure>, StructureRegistrar.StructureBuilder<DEModularStructure>> configuratorConsumer) {
        DESinglePieceFactory pieceFactory = new DESinglePieceFactory(template, () -> (StructurePieceType)this._registrar.get().getPieceType().get());
        DEModularStructure.Builder structureBuilder = new DEModularStructure.Builder(pieceFactory, () -> this._registrar.get().getType());
        structureBuilder = builderConsumer.apply(structureBuilder);
        return this.addStructure(pieceFactory, structureBuilder, configuratorConsumer);
    }

    public DEModularRegistrarBuilder addStructure(IDEPieceFactory pieceFactory, DEModularStructure.Builder structureBuilder, Function<StructureRegistrar.StructureBuilder<DEModularStructure>, StructureRegistrar.StructureBuilder<DEModularStructure>> configuratorConsumer) {
        this._builder.addPiece(() -> pieceFactory::createPiece);
        if (this._codec == null) {
            this._codec = Structure.simpleCodec(structureBuilder::build);
        }
        StructureRegistrar.StructureBuilder configurator = this._builder.pushStructure(structureBuilder::build);
        configuratorConsumer.apply((StructureRegistrar.StructureBuilder<DEModularStructure>)configurator);
        configurator.popStructure();
        return this;
    }

    public StructureRegistrar<DEModularStructure> build() {
        if (this._codec == null) {
            throw new IllegalArgumentException("codec was not given and could not be constructed");
        }
        return this._builder.placement(() -> this._placement.build(this._registrar.get().getRegistryName())).build();
    }
}

