/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.builder.DEPlacementFilter;
import com.barion.dungeons_enhanced.world.structure.builder.DESimpleStructurePiece;
import com.barion.dungeons_enhanced.world.structure.builder.IDEPieceFactory;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

@FunctionalInterface
public interface DEPlacement {
    public static final DEPlacement WORLD_SURFACE_FLAT = (context, filter, pieceFactory) -> {
        DESimpleStructurePiece piece;
        Vec3i size;
        BlockPos rawPos = DEUtil.chunkPosToBlockPos(context.chunkPos(), 0);
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size = (piece = pieceFactory.createPiece(context.structureTemplateManager(), rawPos, (RandomSource)context.random())).getSize(), 1, 4, Heightmap.Types.WORLD_SURFACE_WG, context.chunkGenerator(), context.heightAccessor(), context.randomState());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            return Optional.empty();
        }
        BlockPos pos = rawPos.atY(Math.round(((Float)result.getFirst()).floatValue()));
        if (filter.cannotGenerate(pos, context)) {
            return Optional.empty();
        }
        piece.setPosition(pos);
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)piece)));
    };
    public static final DEPlacement OCEAN_FLOOR = (context, filter, pieceFactory) -> {
        DESimpleStructurePiece piece;
        Vec3i size;
        BlockPos rawPos = DEUtil.chunkPosToBlockPos(context.chunkPos(), 0);
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size = (piece = pieceFactory.createPiece(context.structureTemplateManager(), rawPos, (RandomSource)context.random())).getSize(), 1, 4, context.chunkGenerator(), context.heightAccessor(), context.randomState());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            return Optional.empty();
        }
        BlockPos pos = rawPos.atY(Math.round(((Float)result.getFirst()).floatValue()));
        if (filter.cannotGenerate(pos, context)) {
            return Optional.empty();
        }
        piece.setPosition(pos);
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)piece)));
    };
    public static final DEPlacement ABOVE_GROUND = (context, filter, pieceFactory) -> {
        BlockPos pos;
        BlockPos rawPos = DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        if (rawPos.getY() > 224) {
            return Optional.empty();
        }
        int minY = rawPos.getY() + 48;
        int maxY = 288;
        int y = 288;
        if (288 > minY) {
            y = minY + context.random().nextInt(288 - minY);
        }
        if (filter.cannotGenerate(pos = rawPos.atY(y), context)) {
            return Optional.empty();
        }
        DESimpleStructurePiece piece = pieceFactory.createPiece(context.structureTemplateManager(), pos, (RandomSource)context.random());
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)piece)));
    };
    public static final DEPlacement UNDERGROUND = (context, filter, pieceFactory) -> {
        BlockPos pos;
        int maxY;
        BlockPos groundPos = DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        if (groundPos.getY() < 0) {
            return Optional.empty();
        }
        int minY = context.chunkGenerator().getMinY() + 8;
        int y = maxY = groundPos.getY() - 32;
        if (maxY > minY) {
            y = minY + context.random().nextInt(maxY - minY);
        }
        if (filter.cannotGenerate(pos = groundPos.atY(y), context)) {
            return Optional.empty();
        }
        DESimpleStructurePiece piece = pieceFactory.createPiece(context.structureTemplateManager(), pos, (RandomSource)context.random());
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)piece)));
    };
    public static final DEPlacement WORLD_SURFACE = (context, filter, pieceFactory) -> {
        BlockPos pos = DEUtil.chunkPosToBlockPosFromHeightMap(context.chunkPos(), context.chunkGenerator(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        DESimpleStructurePiece piece = pieceFactory.createPiece(context.structureTemplateManager(), pos, (RandomSource)context.random());
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)piece)));
    };

    public Optional<Structure.GenerationStub> getPlacement(Structure.GenerationContext var1, DEPlacementFilter var2, IDEPieceFactory var3);
}

