/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

@FunctionalInterface
public interface DEPlacementFilter {
    public static final DEPlacementFilter NO_WATER = (pos, context) -> context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState()).getBlock(pos.getY()).is(Blocks.WATER);

    public static DEPlacementFilter MaxWaterDepth(int maxDifference) {
        return (pos, context) -> {
            int oceanFloor = context.chunkGenerator().getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
            int dif = Math.abs(pos.getY() - oceanFloor);
            return dif > maxDifference;
        };
    }

    public static DEPlacementFilter MinWaterHeight(int minDifference) {
        return (pos, context) -> {
            int oceanFloor = context.chunkGenerator().getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
            int dif = Math.abs(pos.getY() - oceanFloor);
            return dif < minDifference;
        };
    }

    public boolean cannotGenerate(BlockPos var1, Structure.GenerationContext var2);
}

