/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.world.structure.builder.DESimpleStructurePiece;
import com.barion.dungeons_enhanced.world.structure.builder.DEStructureTemplate;
import com.barion.dungeons_enhanced.world.structure.builder.IDEPieceFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class DERandomPieceFactory
implements IDEPieceFactory {
    private final SimpleWeightedRandomList<DEStructureTemplate> _templates;
    private final Supplier<StructurePieceType> _pieceTypeSupplier;
    private final Function<StructurePlaceSettings, StructurePlaceSettings> _settingsFunction;

    public DERandomPieceFactory(SimpleWeightedRandomList<DEStructureTemplate> templates, Supplier<StructurePieceType> pieceTypeSupplier, Function<StructurePlaceSettings, StructurePlaceSettings> settingsFunction) {
        this._settingsFunction = settingsFunction;
        if (templates.isEmpty()) {
            throw new IllegalArgumentException("The template list is empty");
        }
        this._pieceTypeSupplier = pieceTypeSupplier;
        this._templates = templates;
    }

    @Override
    public StructurePiece createPiece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
        return new DESimpleStructurePiece(this._pieceTypeSupplier.get(), nbt, serializationContext, this._settingsFunction);
    }

    @Override
    public DESimpleStructurePiece createPiece(StructureTemplateManager templateManager, BlockPos position, RandomSource random) {
        DEStructureTemplate template = (DEStructureTemplate)this._templates.getRandomValue(random).get();
        return new DESimpleStructurePiece(this._pieceTypeSupplier.get(), templateManager, template.resourceLocation(), position, this._settingsFunction, template.yOffset(), Rotation.getRandom((RandomSource)random));
    }

    public static class Builder {
        private final SimpleWeightedRandomList.Builder<DEStructureTemplate> _templates = new SimpleWeightedRandomList.Builder();
        private Function<StructurePlaceSettings, StructurePlaceSettings> _settingsFunction = settings -> settings;

        public Builder settings(Function<StructurePlaceSettings, StructurePlaceSettings> settingsFunction) {
            this._settingsFunction = settingsFunction;
            return this;
        }

        public Builder add(String location) {
            return this.add(DungeonsEnhanced.locate(location));
        }

        public Builder add(int weight, String location) {
            return this.add(weight, DungeonsEnhanced.locate(location), 0);
        }

        public Builder add(int weight, String location, int yOffset) {
            return this.add(weight, DungeonsEnhanced.locate(location), yOffset);
        }

        public Builder add(ResourceLocation resourceLocation) {
            return this.add(1, resourceLocation, 0);
        }

        public Builder add(int weight, ResourceLocation resourceLocation, int yOffset) {
            return this.add(weight, new DEStructureTemplate(resourceLocation, yOffset));
        }

        public Builder add(DEStructureTemplate template) {
            return this.add(1, template);
        }

        public Builder add(int weight, DEStructureTemplate template) {
            this._templates.add((Object)template, weight);
            return this;
        }

        public DERandomPieceFactory build(Supplier<StructurePieceType> pieceTypeSupplier) {
            return new DERandomPieceFactory((SimpleWeightedRandomList<DEStructureTemplate>)this._templates.build(), pieceTypeSupplier, this._settingsFunction);
        }
    }
}

