/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class DESimpleStructurePiece
extends GelTemplateStructurePiece {
    private final Function<StructurePlaceSettings, StructurePlaceSettings> _settingsFunction;
    public final int yOffset;

    public DESimpleStructurePiece(StructurePieceType structurePieceType, StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Function<StructurePlaceSettings, StructurePlaceSettings> settingsFunction, int yOffset, Rotation rotation) {
        super(structurePieceType, 0, structureManager, templateName, pos.above(yOffset));
        this._settingsFunction = settingsFunction;
        this.yOffset = yOffset;
        this.rotation = rotation;
        this.setupPlaceSettings(structureManager);
    }

    public DESimpleStructurePiece(StructurePieceType structurePieceType, CompoundTag nbt, StructurePieceSerializationContext context, Function<StructurePlaceSettings, StructurePlaceSettings> settingsFunction) {
        super(structurePieceType, nbt, context.structureTemplateManager());
        this._settingsFunction = settingsFunction;
        this.yOffset = 0;
        this.setupPlaceSettings(context.structureTemplateManager());
    }

    protected StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
        Vec3i size = this.template().getSize(this.rotation);
        BlockPos pivot = new BlockPos(size.getX() / 2, 0, size.getZ() / 2);
        return this._settingsFunction.apply(super.getPlaceSettings(structureManager).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING).setRotationPivot(pivot));
    }

    public Vec3i getSize() {
        return this.template().getSize(this.getRotation());
    }

    public void setPosition(BlockPos pos) {
        this.templatePosition = pos.above(this.yOffset);
        this.boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
    }

    @ParametersAreNonnullByDefault
    protected void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor levelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
    }
}

