/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.builder;

import com.barion.dungeons_enhanced.world.structure.builder.DESimpleStructurePiece;
import com.barion.dungeons_enhanced.world.structure.builder.DEStructureTemplate;
import com.barion.dungeons_enhanced.world.structure.builder.IDEPieceFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class DESinglePieceFactory
implements IDEPieceFactory {
    private final DEStructureTemplate _template;
    private final Supplier<StructurePieceType> _pieceTypeSupplier;
    private final Function<StructurePlaceSettings, StructurePlaceSettings> _settingsFunction;

    public DESinglePieceFactory(DEStructureTemplate template, Supplier<StructurePieceType> pieceTypeSupplier) {
        this(template, pieceTypeSupplier, settings -> settings);
    }

    public DESinglePieceFactory(DEStructureTemplate template, Supplier<StructurePieceType> pieceTypeSupplier, Function<StructurePlaceSettings, StructurePlaceSettings> settingsFunction) {
        this._template = template;
        this._pieceTypeSupplier = pieceTypeSupplier;
        this._settingsFunction = settingsFunction;
    }

    @Override
    public DESimpleStructurePiece createPiece(StructureTemplateManager templateManager, BlockPos position, RandomSource random) {
        return new DESimpleStructurePiece(this._pieceTypeSupplier.get(), templateManager, this._template.resourceLocation(), position, this._settingsFunction, this._template.yOffset(), Rotation.getRandom((RandomSource)random));
    }

    @Override
    public StructurePiece createPiece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
        return new DESimpleStructurePiece(this._pieceTypeSupplier.get(), nbt, serializationContext, this._settingsFunction);
    }
}

