/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class DEBaseStructure
extends Structure {
    protected final DEStructureTemplates _templates;
    protected final Supplier<StructureType<?>> _typeSupplier;

    public DEBaseStructure(Structure.StructureSettings settings, DEStructureTemplates templates, Supplier<StructureType<?>> type) {
        super(settings);
        this._templates = templates;
        this._typeSupplier = type;
    }

    protected static Optional<Structure.GenerationStub> at(BlockPos pos, Consumer<StructurePiecesBuilder> piecesBuilder) {
        return Optional.of(new Structure.GenerationStub(pos, piecesBuilder));
    }

    @Nonnull
    public StructureType<?> type() {
        return this._typeSupplier.get();
    }

    protected static void generatePieces(StructurePiecesBuilder piecesBuilder, BlockPos pos, DEStructureTemplates.Template template, Rotation rotation, Structure.GenerationContext context, DEPieceAssembler assembler) {
        assembler.assemble(new DEPieceAssembler.Context(context.structureTemplateManager(), template.Resource, pos, rotation, piecesBuilder));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        private Rotation _rotation;

        public Piece(Registrar.Static<StructurePieceType> pieceType, StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)pieceType.get(), 0, structureManager, templateName, pos);
            this._rotation = rotation;
            this.setupPlaceSettings(structureManager);
        }

        public Piece(Registrar.Static<StructurePieceType> pieceType, StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)pieceType.get(), nbt, context.structureTemplateManager());
            this.setupPlaceSettings(context.structureTemplateManager());
        }

        protected StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
            Vec3i size = ((StructureTemplate)structureManager.get(this.makeTemplateLocation()).get()).getSize();
            BlockPos pivot = new BlockPos(size.getX() / 2, 0, size.getZ() / 2);
            StructurePlaceSettings settings = super.getPlaceSettings(structureManager).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING).setRotationPivot(pivot).setRotation(this._rotation);
            settings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            this.addProcessors(settings);
            return settings;
        }

        protected void addProcessors(StructurePlaceSettings settings) {
        }

        @ParametersAreNonnullByDefault
        protected void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        }
    }
}

