/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.builder.DEPlacementFilter;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEGroundStructure
extends DEBaseStructure {
    public static final MapCodec<DEGroundStructure> CODEC_JUNGLE_MONUMENT = DEGroundStructure.simpleCodec(DEGroundStructure::JungleMonument);
    public static final MapCodec<DEGroundStructure> CODEC_MINERS_HOUSE = DEGroundStructure.simpleCodec(DEGroundStructure::MinersHouse);
    public static final MapCodec<DEGroundStructure> CODEC_MUSHROOM_HOUSE = DEGroundStructure.simpleCodec(DEGroundStructure::MushroomHouse);
    public static final MapCodec<DEGroundStructure> CODEC_WATCH_TOWER = DEGroundStructure.simpleCodec(DEGroundStructure::WatchTower);
    public static final MapCodec<DEGroundStructure> CODEC_WITCH_TOWER = DEGroundStructure.simpleCodec(DEGroundStructure::WitchTower);

    public static DEGroundStructure JungleMonument(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().yOffset(-9).add("jungle_monument").build(), () -> DEStructures.JUNGLE_MONUMENT.getType());
    }

    public static DEGroundStructure MinersHouse(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add("miners_house").build(), () -> DEStructures.MINERS_HOUSE.getType());
    }

    public static DEGroundStructure MushroomHouse(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add("mushroom_house/red").add("mushroom_house/brown").build(), () -> DEStructures.MUSHROOM_HOUSE.getType());
    }

    public static DEGroundStructure WatchTower(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().add("watch_tower").build(), () -> DEStructures.WATCH_TOWER.getType());
    }

    public static DEGroundStructure WitchTower(Structure.StructureSettings settings) {
        return new DEGroundStructure(settings, DEUtil.pieceBuilder().weight(3).add("witch_tower/normal").weight(2).add("witch_tower/big").build(), () -> DEStructures.WITCH_TOWER.getType());
    }

    public DEGroundStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    protected static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().addPiece((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    @Nonnull
    public Optional<Structure.GenerationStub> findGenerationPoint(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template piece = this._templates.getRandom((RandomSource)context.random());
        BlockPos rawPos = this.getGenPos(context.chunkPos()).above(piece.yOffset);
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        Vec3i size = context.structureTemplateManager().getOrCreate(piece.Resource).getSize(rotation);
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size, 1, 4, context.chunkGenerator(), context.heightAccessor(), context.randomState());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            return Optional.empty();
        }
        BlockPos pos = rawPos.atY(Math.round(((Float)result.getFirst()).floatValue())).above(piece.yOffset);
        if (DEPlacementFilter.NO_WATER.cannotGenerate(pos, context)) {
            return Optional.empty();
        }
        return DEGroundStructure.at(pos, builder -> DEGroundStructure.generatePieces(builder, pos, piece, rotation, context, DEGroundStructure::assemble));
    }

    protected BlockPos getGenPos(ChunkPos chunkPos) {
        return DEUtil.chunkPosToBlockPos(chunkPos, 0);
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.RUINED_BUILDING.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.RUINED_BUILDING.getPieceType(), serializationContext, nbt);
        }
    }
}

