/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.world.structure.builder.DEPlacement;
import com.barion.dungeons_enhanced.world.structure.builder.DEPlacementFilter;
import com.barion.dungeons_enhanced.world.structure.builder.IDEPieceFactory;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.jetbrains.annotations.NotNull;

public final class DEModularStructure
extends Structure {
    private final IDEPieceFactory _pieceFactory;
    private final DEPlacement _placementProvider;
    private final ImmutableList<DEPlacementFilter> _filters;
    private final Supplier<StructureType<?>> _typeSupplier;

    public DEModularStructure(Structure.StructureSettings settings, IDEPieceFactory pieceFactory, DEPlacement placement, ImmutableList<DEPlacementFilter> filters, Supplier<StructureType<?>> typeSupplier) {
        super(settings);
        this._pieceFactory = pieceFactory;
        this._placementProvider = placement;
        this._filters = filters;
        this._typeSupplier = typeSupplier;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext context) {
        return this._placementProvider.getPlacement(context, this::cannotGenerate, this._pieceFactory);
    }

    public boolean cannotGenerate(BlockPos pos, Structure.GenerationContext context) {
        for (DEPlacementFilter filter : this._filters) {
            if (!filter.cannotGenerate(pos, context)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public StructureType<?> type() {
        return this._typeSupplier.get();
    }

    public static class Builder {
        private final IDEPieceFactory _pieceFactory;
        private DEPlacement _placementProvider;
        private final List<DEPlacementFilter> _filters = new ArrayList<DEPlacementFilter>();
        private final Supplier<StructureType<?>> _typeSupplier;

        public Builder(IDEPieceFactory pieceFactory, Supplier<StructureType<?>> typeSupplier) {
            this._pieceFactory = pieceFactory;
            this._typeSupplier = typeSupplier;
        }

        public Builder placement(DEPlacement placement) {
            this._placementProvider = placement;
            return this;
        }

        public Builder filter(DEPlacementFilter filter) {
            this._filters.add(filter);
            return this;
        }

        public DEModularStructure build(Structure.StructureSettings settings) {
            if (this._placementProvider == null) {
                throw new IllegalArgumentException("placement not set");
            }
            return new DEModularStructure(settings, this._pieceFactory, this._placementProvider, (ImmutableList<DEPlacementFilter>)ImmutableList.copyOf(this._filters), this._typeSupplier);
        }
    }
}

