/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs.utils;

import com.barion.dungeons_enhanced.DungeonsEnhanced;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import org.jetbrains.annotations.NotNull;

public final class DEStructureTemplates {
    private final SimpleWeightedRandomList<Template> templates;

    public DEStructureTemplates(@NotNull Builder builder) {
        this(builder.buildList());
    }

    public DEStructureTemplates(@NotNull SimpleWeightedRandomList<Template> templates) {
        if (templates.isEmpty()) {
            throw new IllegalArgumentException("The Structure Template builder is empty");
        }
        this.templates = templates;
    }

    public Template getRandom(RandomSource random) {
        return (Template)this.templates.getRandomValue(random).get();
    }

    public static class Builder {
        private final SimpleWeightedRandomList.Builder<Template> pieces = SimpleWeightedRandomList.builder();
        private int yOffset = 0;
        private int weight = 1;

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder yOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public Builder add(String resource) {
            this.pieces.add((Object)new Template(DungeonsEnhanced.locate(resource), this.yOffset), this.weight);
            return this;
        }

        @NotNull
        private SimpleWeightedRandomList<Template> buildList() {
            return this.pieces.build();
        }

        public DEStructureTemplates build() {
            return new DEStructureTemplates(this);
        }
    }

    public static class Template {
        public final ResourceLocation Resource;
        public final int yOffset;

        public Template(ResourceLocation resource, int offset) {
            this.Resource = resource;
            this.yOffset = offset;
        }
    }
}

