/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.processor;

import com.barion.dungeons_enhanced.registry.DEProcessorTypes;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DESwapDeadCoralsProcessor
extends StructureProcessor {
    public static final DESwapDeadCoralsProcessor INSTANCE = new DESwapDeadCoralsProcessor();
    public static final MapCodec<DESwapDeadCoralsProcessor> CODEC = MapCodec.unit((Object)((Object)INSTANCE));
    private static final Map<Block, Block> DEATH_TO_LIVING_CORAL = new ImmutableMap.Builder().put((Object)Blocks.DEAD_BRAIN_CORAL, (Object)Blocks.BRAIN_CORAL).put((Object)Blocks.DEAD_BUBBLE_CORAL, (Object)Blocks.BUBBLE_CORAL).put((Object)Blocks.DEAD_FIRE_CORAL, (Object)Blocks.FIRE_CORAL).put((Object)Blocks.DEAD_HORN_CORAL, (Object)Blocks.HORN_CORAL).put((Object)Blocks.DEAD_TUBE_CORAL, (Object)Blocks.TUBE_CORAL).put((Object)Blocks.DEAD_BRAIN_CORAL_BLOCK, (Object)Blocks.BRAIN_CORAL_BLOCK).put((Object)Blocks.DEAD_BUBBLE_CORAL_BLOCK, (Object)Blocks.BUBBLE_CORAL_BLOCK).put((Object)Blocks.DEAD_FIRE_CORAL_BLOCK, (Object)Blocks.FIRE_CORAL_BLOCK).put((Object)Blocks.DEAD_HORN_CORAL_BLOCK, (Object)Blocks.HORN_CORAL_BLOCK).put((Object)Blocks.DEAD_TUBE_CORAL_BLOCK, (Object)Blocks.TUBE_CORAL_BLOCK).put((Object)Blocks.DEAD_BRAIN_CORAL_FAN, (Object)Blocks.BRAIN_CORAL_FAN).put((Object)Blocks.DEAD_BUBBLE_CORAL_FAN, (Object)Blocks.BUBBLE_CORAL_FAN).put((Object)Blocks.DEAD_FIRE_CORAL_FAN, (Object)Blocks.FIRE_CORAL_FAN).put((Object)Blocks.DEAD_HORN_CORAL_FAN, (Object)Blocks.HORN_CORAL_FAN).put((Object)Blocks.DEAD_TUBE_CORAL_FAN, (Object)Blocks.TUBE_CORAL_FAN).put((Object)Blocks.DEAD_BRAIN_CORAL_WALL_FAN, (Object)Blocks.BRAIN_CORAL_WALL_FAN).put((Object)Blocks.DEAD_BUBBLE_CORAL_WALL_FAN, (Object)Blocks.BUBBLE_CORAL_WALL_FAN).put((Object)Blocks.DEAD_FIRE_CORAL_WALL_FAN, (Object)Blocks.FIRE_CORAL_WALL_FAN).put((Object)Blocks.DEAD_HORN_CORAL_WALL_FAN, (Object)Blocks.HORN_CORAL_WALL_FAN).put((Object)Blocks.DEAD_TUBE_CORAL_WALL_FAN, (Object)Blocks.TUBE_CORAL_WALL_FAN).build();

    private DESwapDeadCoralsProcessor() {
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo existing, StructureTemplate.StructureBlockInfo placed, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        if (!DEATH_TO_LIVING_CORAL.containsKey(placed.state().getBlock())) {
            return placed;
        }
        BlockState livingCoral = DEATH_TO_LIVING_CORAL.get(placed.state().getBlock()).withPropertiesOf(placed.state());
        return new StructureTemplate.StructureBlockInfo(placed.pos(), livingCoral, null);
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return DEProcessorTypes.SWAP_DEAD_CORALS_PROCESSOR;
    }
}

