/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.tuple.Triple;

public enum StructurePlacement implements StringRepresentable
{
    SURFACE((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 10, 3.0, BlockBehaviour.BlockStateBase::isSolid)),
    CEILING((context, box) -> {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            for (int y = context.heightAccessor().getMinY() + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                return pos.setY(y);
            }
            return null;
        }).collect(Collectors.toList());
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int[] heights = positions.stream().mapToInt(Vec3i::getY).toArray();
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > 4.0) {
            return null;
        }
        return average;
    }),
    ON_WATER((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 1, 1.0, state -> state.is(Blocks.WATER))),
    ON_LAVA((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 1, 1.0, state -> state.is(Blocks.LAVA))),
    UNDERGROUND((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            int lowest = context.heightAccessor().getMinY();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.heightAccessor().getMinY()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.getYSpan()) {
            return null;
        }
        return min + 1 + context.random().nextInt(max - min - box.getYSpan() - 2);
    }),
    UNDERGROUND_SURFACE((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            int lowest = context.heightAccessor().getMinY();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.heightAccessor().getMinY()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.getYSpan()) {
            return null;
        }
        int height = min + 1 + context.random().nextInt(max - min - box.getYSpan() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.getBlock(y).isAir(); --y, ++i) {
            }
            if (!column.getBlock(y).isAir()) {
                return null;
            }
            --y;
            for (i = 0; i < 20 && column.getBlock(y).isAir(); ++i) {
                --y;
            }
            if (!column.getBlock(y).isSolid()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_CEILING((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            int lowest = context.heightAccessor().getMinY();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.heightAccessor().getMinY()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.getYSpan()) {
            return null;
        }
        int height = min + 1 + context.random().nextInt(max - min - box.getYSpan() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.getBlock(y).isAir(); ++y, ++i) {
            }
            if (!column.getBlock(y).isAir()) {
                return null;
            }
            ++y;
            for (i = 0; i < 30 && column.getBlock(y).isAir(); ++i) {
                ++y;
            }
            if (!column.getBlock(y).isSolid()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_BURIED((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            int lowest = context.heightAccessor().getMinY();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.heightAccessor().getMinY()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.getYSpan()) {
            return null;
        }
        int ySpan = box.getYSpan();
        int height = min + ySpan + 1 + context.random().nextInt(max - min - ySpan - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.getBlock(y).isSolid(); --y, ++i) {
            }
            if (!column.getBlock(y).isSolid()) {
                return null;
            }
            y -= 2;
            for (i = 0; i < ySpan; ++i) {
                if (!column.getBlock(y).isSolid()) {
                    return null;
                }
                --y;
            }
            if (!column.getBlock(y).isSolid() || !column.getBlock(y - 1).isSolid()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (!positions.stream().allMatch(t -> {
            NoiseColumn column = (NoiseColumn)t.getLeft();
            return column.getBlock(average).isSolid() && column.getBlock(average + ySpan).isSolid();
        })) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_ON_LAVA((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), context.heightAccessor().getMaxY());
            NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
            int lowest = context.heightAccessor().getMinY();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.getBlock(y).isAir()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.heightAccessor().getMinY()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 < box.getYSpan()) {
            return null;
        }
        int height = min + 1 + context.random().nextInt(max - min - box.getYSpan() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.getBlock(y).isAir(); --y, ++i) {
            }
            if (!column.getBlock(y).isAir()) {
                return null;
            }
            --y;
            for (i = 0; i < 40 && column.getBlock(y).isAir(); ++i) {
                --y;
            }
            if (!column.getBlock(y).is(Blocks.LAVA)) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    });

    public static final Codec<StructurePlacement> CODEC;
    final BiFunction<Structure.GenerationContext, BoundingBox, Integer> locator;

    private StructurePlacement(BiFunction<Structure.GenerationContext, BoundingBox, Integer> locator) {
        this.locator = locator;
    }

    public Optional<Integer> findHeight(Structure.GenerationContext context, BoundingBox boundingBox) {
        return Optional.ofNullable(this.locator.apply(context, boundingBox));
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static Stream<BlockPos.MutableBlockPos> cornersAndCenter(BoundingBox box) {
        BlockPos center = box.getCenter();
        return Stream.of(new BlockPos.MutableBlockPos(box.minX(), 0, box.minZ()), new BlockPos.MutableBlockPos(box.minX(), 0, box.maxZ()), new BlockPos.MutableBlockPos(box.maxX(), 0, box.maxZ()), new BlockPos.MutableBlockPos(box.maxX(), 0, box.minZ()), new BlockPos.MutableBlockPos(center.getX(), 0, center.getZ()));
    }

    private static Integer findFromTop(Structure.GenerationContext context, BoundingBox box, Heightmap.Types heightmap, int maxOffset, double maxAverageOffset, Predicate<BlockState> target) {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> pos.setY(context.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), heightmap, context.heightAccessor(), context.randomState()))).collect(Collectors.toList());
        int[] heights = positions.stream().mapToInt(Vec3i::getY).toArray();
        if (IntStream.of(heights).anyMatch(y -> y <= context.heightAccessor().getMinY())) {
            return null;
        }
        if (positions.stream().anyMatch(pos -> !target.test(context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState()).getBlock(pos.getY())))) {
            return null;
        }
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).max().getAsInt() > maxOffset) {
            return null;
        }
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > maxAverageOffset) {
            return null;
        }
        return average;
    }

    static {
        CODEC = StringRepresentable.fromEnum(StructurePlacement::values);
    }
}

