/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.loot_table;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.formations.tools.loot_table.LootTableEditingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class OpenLootTableScreenPacket
implements BasePacket {
    private BlockPos pos;
    private ResourceLocation original;

    public OpenLootTableScreenPacket(BlockPos pos, ResourceLocation original) {
        this.pos = pos;
        this.original = original;
    }

    public OpenLootTableScreenPacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBoolean(this.original != null);
        if (this.original != null) {
            buffer.writeResourceLocation(this.original);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.original = buffer.readBoolean() ? buffer.readResourceLocation() : null;
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide() == CoreSide.CLIENT) {
            ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new LootTableEditingScreen(this.pos, this.original)));
        }
    }
}

