/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.screen.widget;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000f8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/fzzyhmstrs/fzzy_config/screen/widget/ClickableTextWidget;", "Lnet/minecraft/client/gui/components/AbstractStringWidget;", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "Lnet/minecraft/network/chat/Component;", "message", "Lnet/minecraft/client/gui/Font;", "textRenderer", "<init>", "(Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/Font;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "text", "width", "Lnet/minecraft/util/FormattedCharSequence;", "trim", "(Lnet/minecraft/network/chat/Component;I)Lnet/minecraft/util/FormattedCharSequence;", "", "button", "", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/screens/Screen;", "horizontalAlignment", "F", "fzzy_config"})
public final class ClickableTextWidget
extends AbstractStringWidget {
    @NotNull
    private final Screen parent;
    private final float horizontalAlignment;

    public ClickableTextWidget(@NotNull Screen parent, @NotNull Component message, @NotNull Font textRenderer) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        super(0, 0, textRenderer.width(message.getVisualOrderText()), textRenderer.lineHeight, message, textRenderer);
        this.parent = parent;
        this.horizontalAlignment = 0.5f;
    }

    protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        FormattedCharSequence formattedCharSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Component text = this.getMessage();
        int i = this.getWidth();
        int j = this.getFont().width((FormattedText)text);
        int k = this.getX() + MathKt.roundToInt((float)(this.horizontalAlignment * (float)(i - j)));
        int l = this.getY() + (this.getHeight() - this.getFont().lineHeight) / 2;
        if (j > i) {
            Intrinsics.checkNotNull((Object)text);
            formattedCharSequence = this.trim(text, i);
        } else {
            formattedCharSequence = text.getVisualOrderText();
        }
        FormattedCharSequence orderedText = formattedCharSequence;
        context.drawString(this.getFont(), orderedText, k, l, this.getColor());
    }

    private final FormattedCharSequence trim(Component text, int width) {
        FormattedText stringVisitable = this.getFont().substrByWidth((FormattedText)text, width - this.getFont().width((FormattedText)CommonComponents.ELLIPSIS));
        FormattedText[] formattedTextArray = new FormattedText[]{stringVisitable, CommonComponents.ELLIPSIS};
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])formattedTextArray));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        double d = mouseX - (double)this.getX();
        Style style = this.getFont().getSplitter().componentStyleAtWidth(this.getMessage().getVisualOrderText(), Mth.floor((double)d));
        if (style == null) {
            return false;
        }
        Style style2 = style;
        return this.parent.handleComponentClicked(style2);
    }
}

