/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.ichun.mods.ichunutil.client.core.ResourceHelper;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import org.jetbrains.annotations.NotNull;

public class ConfigClient
extends ConfigBase {
    @CategoryDivider(name="bns")
    @Prop(min=0.0, max=2.0)
    public int bnsMinecraftStyle = 0;
    @Prop(min=0.0, max=50.0)
    public int bnsDockPadding = 0;
    @Prop(min=1.0)
    public int bnsDockBorder = 8;
    @Prop(min=1.0)
    public int bnsDoubleClickSpeed = 10;
    @Prop(min=0.0, max=6000.0)
    public int bnsTooltipCooldown = 10;
    @Prop(guiElementOverride="iChunUtil:bnsTheme")
    public String bnsTheme = "default";

    public ConfigClient() {
        super(new String[0]);
    }

    @Override
    public boolean addToSubfolder() {
        return true;
    }

    @Override
    public void registerGuiElementOverrides() {
        this.guiElementOverrides.put("iChunUtil:bnsTheme", (entry, item) -> {
            Object o;
            Field field = entry.field;
            field.setAccessible(true);
            try {
                o = field.get(this);
            }
            catch (IllegalAccessException e) {
                iChunUtil.LOGGER.error("Error accessing config field {} when creating config. Skipping creation of this config option.", (Object)field.getName(), (Object)e);
                return true;
            }
            ArrayList<Path> files = new ArrayList<Path>();
            try (Stream<Path> paths = Files.list(ResourceHelper.getThemesDir());){
                files.addAll(paths.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".json")).toList());
            }
            catch (IOException e) {
                iChunUtil.LOGGER.error("Error reading themes folder!", (Throwable)e);
            }
            Collections.sort(files);
            ElementDropdownContextMenu<Path> input = new ElementDropdownContextMenu((Fragment<?>)item, o.toString(), files, (menu, listItem) -> {
                if (listItem.selected) {
                    Path path = (Path)listItem.getObject();
                    menu.text = path.getFileName().toString().substring(0, path.getFileName().toString().length() - 5);
                    if (Theme.loadTheme(path)) {
                        try {
                            field.set(this, menu.text);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
            }).setNameProvider(path -> List.of(path.getFileName().toString().substring(0, path.getFileName().toString().length() - 5)));
            input.setSize(80, 14);
            input.setConstraint(new Constraint(input).top((Rectangle)item, Constraint.Property.Type.TOP, 3).bottom((Rectangle)item, Constraint.Property.Type.BOTTOM, 3).right((Rectangle)item, Constraint.Property.Type.RIGHT, 8));
            item.addElement(input);
            return true;
        });
    }

    @Override
    public void onConfigLoaded() {
        Theme.loadTheme(ResourceHelper.getThemesDir().resolve(this.bnsTheme + ".json"));
    }

    @Override
    public void onPropertyChanged(boolean file, String name, Field field, Object oldObj, Object newObj) {
        if (name.equals("bnsTheme")) {
            Theme.loadTheme(ResourceHelper.getThemesDir().resolve(String.valueOf(newObj) + ".json"));
        }
    }

    @Override
    @NotNull
    public String getModId() {
        return "ichunutil";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "iChunUtil";
    }

    @Override
    public ConfigBase.Type getConfigType() {
        return ConfigBase.Type.CLIENT;
    }
}

