/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns;

import java.util.List;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.TextureDefinition;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Fragment<P extends Rectangle>
implements Rectangle,
Constrainable,
ContainerEventHandler {
    private static final ResourceLocation VANILLA_HORSE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/horse.png");
    private static final ResourceLocation HORSE = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/horse.png");
    private static final ResourceLocation VANILLA_TAB_ITEMS = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tab_items.png");
    private static final ResourceLocation TAB_ITEMS = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/tab_items.png");
    public static final TextureDefinition TEXDEF_SCROLLER = new TextureDefinition(12.0, 15.0, 0, 12, 0, 15, 2, 2, 2, 10, 2, 13);
    private static final ResourceLocation VANILLA_SCROLLER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/container/creative_inventory/scroller.png");
    private static final ResourceLocation SCROLLER = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/scroller.png");
    public static final TextureDefinition TEXDEF_UP = new TextureDefinition(32.0, 32.0, 3, 14, 3, 14, 0, 0, 3, 14, 3, 14);
    private static final ResourceLocation VANILLA_UP = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/server_list/move_up.png");
    private static final ResourceLocation UP = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/move_up.png");
    public static final TextureDefinition TEXDEF_DOWN = new TextureDefinition(32.0, 32.0, 3, 14, 18, 29, 0, 0, 3, 14, 18, 29);
    private static final ResourceLocation VANILLA_DOWN = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/server_list/move_down.png");
    private static final ResourceLocation DOWN = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/move_down.png");
    public static final TextureDefinition TEXDEF_BUTTON = new TextureDefinition(200.0, 20.0, 0, 200, 0, 20, 3, 3, 3, 197, 3, 17);
    private static final ResourceLocation VANILLA_BUTTON = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/button.png");
    private static final ResourceLocation VANILLA_BUTTON_DISABLED = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/button_disabled.png");
    private static final ResourceLocation VANILLA_BUTTON_HIGHLIGHTED = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/button_highlighted.png");
    private static final ResourceLocation BUTTON = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/button.png");
    private static final ResourceLocation BUTTON_DISABLED = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/button_disabled.png");
    private static final ResourceLocation BUTTON_HIGHLIGHTED = ResourceLocation.fromNamespaceAndPath((String)"ichunutil", (String)"textures/gui/bns/vanilla/button_highlighted.png");
    @NotNull
    public P parent;
    @NotNull
    public Constraint constraint = Constraint.NONE;
    @Nullable
    public String id;
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;
    public int posX;
    public int posY;
    public int width;
    public int height;

    public ResourceLocation resourceHorse() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_HORSE : HORSE;
    }

    public ResourceLocation resourceTabItems() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_TAB_ITEMS : TAB_ITEMS;
    }

    public ResourceLocation resourceScroller() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_SCROLLER : SCROLLER;
    }

    public ResourceLocation resourceUp() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_UP : UP;
    }

    public ResourceLocation resourceDown() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_DOWN : DOWN;
    }

    public ResourceLocation resourceButton(Element.ButtonState state) {
        if (this.renderMinecraftStyle() == 1) {
            return switch (state) {
                case Element.ButtonState.CLICK -> VANILLA_BUTTON_DISABLED;
                case Element.ButtonState.IDLE -> VANILLA_BUTTON;
                default -> VANILLA_BUTTON_HIGHLIGHTED;
            };
        }
        return switch (state) {
            case Element.ButtonState.CLICK -> BUTTON_DISABLED;
            case Element.ButtonState.IDLE -> BUTTON;
            default -> BUTTON_HIGHLIGHTED;
        };
    }

    public Fragment(@NotNull P parent) {
        this.parent = parent;
    }

    public <T extends Fragment<?>> T setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return (T)this;
    }

    public <T extends Fragment<?>> T setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public <T extends Fragment<?>> T setConstraint(Constraint constraint) {
        this.constraint = constraint;
        return (T)this;
    }

    @NotNull
    public Constraint constraints() {
        if (this.constraint == Constraint.NONE) {
            this.constraint = new Constraint(this);
        }
        return this.constraint;
    }

    public <T extends Fragment<?>> T setId(String id) {
        this.id = id;
        return (T)this;
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@NotNull String id) {
        if (id.equals(this.id)) {
            return (T)this;
        }
        T o = null;
        for (Fragment<?> child : this.children()) {
            if (o != null) continue;
            o = child.getById(id);
        }
        return o;
    }

    public abstract List<? extends Fragment<?>> children();

    public void init() {
        this.constraint.apply();
        this.children().forEach(Fragment::init);
    }

    public void onClose() {
        this.children().forEach(Fragment::onClose);
    }

    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        return null;
    }

    public void tick() {
        this.children().forEach(Fragment::tick);
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Fragment<?> frag = this;
            for (GuiEventListener guiEventListener : this.children()) {
                Fragment fragment;
                Fragment<?> fragment1;
                if (!(guiEventListener instanceof Fragment) || (fragment1 = (fragment = (Fragment)guiEventListener).getTopMostFragment(mouseX, mouseY)) == null) continue;
                frag = fragment1;
            }
            return frag;
        }
        return null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        P p = this.parent;
        if (p instanceof Fragment) {
            Fragment fragment = (Fragment)p;
            return fragment.isMouseOver(mouseX, mouseY) && Fragment.isMouseBetween(mouseX, this.getLeft(), this.getRight()) && Fragment.isMouseBetween(mouseY, this.getTop(), this.getBottom());
        }
        return false;
    }

    public static boolean isMouseBetween(double mousePos, double p1, double p2) {
        return mousePos >= p1 && mousePos < p2;
    }

    public boolean requireScissor() {
        return false;
    }

    public void resetScissorToParent() {
        P p = this.parent;
        if (p instanceof Fragment) {
            Fragment fragment = (Fragment)p;
            if (!fragment.requireScissor()) {
                fragment.resetScissorToParent();
            } else {
                fragment.setScissor();
            }
        } else {
            this.endScissor();
        }
    }

    public void setScissor() {
        this.drawBatch();
        RenderHelper.startGlScissor(this.getLeft(), this.getTop(), this.width, this.height);
    }

    public void endScissor() {
        this.drawBatch();
        RenderHelper.endGlScissor();
    }

    protected void drawBatch() {
        RenderHelper.getBufferSource().endBatch();
    }

    public void fill(GuiGraphics graphics, int[] colours, int border) {
        this.fill(graphics, colours, 255, border);
    }

    public void fill(GuiGraphics graphics, int[] colours, int alpha, int border) {
        RenderHelper.drawColour(graphics, colours[0], colours[1], colours[2], alpha, this.getLeft() + border, this.getTop() + border, this.width - border * 2, this.height - border * 2, 0.0);
    }

    public void drawString(GuiGraphics graphics, String s, float posX, float posY) {
        this.drawString(graphics, s, posX, posY, this.renderMinecraftStyle() > 0 ? this.getMinecraftFontColour() : Theme.getAsHex(this.getTheme().font));
    }

    public void drawString(GuiGraphics graphics, String s, float posX, float posY, int color) {
        graphics.drawString(this.getFontRenderer(), s, (int)posX, (int)posY, color, this.renderMinecraftStyle() > 0);
    }

    public int getMinecraftFontColour() {
        return 0xFFFFFF;
    }

    public String reString(String s, int length) {
        if (this.getFontRenderer().width(s) > length) {
            String s1 = s;
            while (this.getFontRenderer().width(s1 + ((Workspace)this.getWorkspace()).ellipsisLength) > length) {
                s1 = s1.substring(0, s1.length() - 1);
            }
            return s1 + "\u2026";
        }
        return s;
    }

    public void resize(Minecraft mc, int width, int height) {
        this.constraint.apply();
        this.children().forEach(child -> child.resize(mc, width, height));
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean b) {
        this.isDragging = b;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener iGuiEventListener) {
        GuiEventListener lastFocused = this.getFocused();
        if (lastFocused instanceof Fragment && iGuiEventListener != lastFocused) {
            ((Fragment)lastFocused).unfocus(iGuiEventListener);
        }
        this.focused = iGuiEventListener;
    }

    public void unfocus(@Nullable GuiEventListener guiReplacing) {
        GuiEventListener lastFocused = this.getFocused();
        if (lastFocused instanceof Fragment && guiReplacing != lastFocused) {
            ((Fragment)lastFocused).unfocus(guiReplacing);
            this.setFocused(null);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            boolean hasElement = super.mouseClicked(mouseX, mouseY, button);
            if (!hasElement && this.getFocused() instanceof Fragment) {
                this.setFocused(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getLeft() {
        return this.parent.getLeft() + this.posX;
    }

    @Override
    public int getRight() {
        return this.parent.getLeft() + this.posX + this.width;
    }

    @Override
    public int getTop() {
        return this.parent.getTop() + this.posY;
    }

    @Override
    public int getBottom() {
        return this.parent.getTop() + this.posY + this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <W extends Workspace> W getWorkspace() {
        return this.parent.getWorkspace();
    }

    @Override
    public Minecraft getMinecraft() {
        return this.parent.getMinecraft();
    }

    @Override
    public Theme getTheme() {
        return this.parent.getTheme();
    }

    @Override
    public Font getFontRenderer() {
        return this.parent.getFontRenderer();
    }

    @Override
    public int renderMinecraftStyle() {
        return this.parent.renderMinecraftStyle();
    }

    @Override
    public void setPosX(int x) {
        this.posX = x;
    }

    @Override
    public void setPosY(int y) {
        this.posY = y;
    }

    @Override
    public void setLeft(int x) {
        this.posX = x - this.parent.getLeft();
    }

    @Override
    public void setRight(int x) {
        this.width = x - this.getLeft();
    }

    @Override
    public void setTop(int y) {
        this.posY = y - this.parent.getTop();
    }

    @Override
    public void setBottom(int y) {
        this.height = y - this.getTop();
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void expandX(int width) {
        if (this.width < width) {
            int lack = width - this.width;
            this.posX -= lack / 2 + lack % 2;
            this.width = width;
        }
    }

    @Override
    public void expandY(int height) {
        if (this.height < height) {
            int lack = height - this.height;
            this.posY -= lack / 2 + lack % 2;
            this.height = height;
        }
    }

    @Override
    public void contractX(int width) {
        if (this.width > width) {
            int lack = this.width - width;
            this.posX += lack / 2 + lack % 2;
            this.width = width;
        }
    }

    @Override
    public void contractY(int height) {
        if (this.height > height) {
            int lack = this.height - height;
            this.posY += lack / 2 + lack % 2;
            this.height = height;
        }
    }

    @Override
    public int getParentWidth() {
        return this.parent.getWidth();
    }

    @Override
    public int getParentHeight() {
        return this.parent.getHeight();
    }

    @Override
    public int getMinWidth() {
        return 1;
    }

    @Override
    public int getMinHeight() {
        return 1;
    }

    @Override
    public int getMaxWidth() {
        return 1000000;
    }

    @Override
    public int getMaxHeight() {
        return 1000000;
    }
}

